package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.Gravity;
import android.widget.LinearLayout;

import com.gingersoft.gsa.cloud.common.constans.AppConstans;
import com.gingersoft.gsa.cloud.common.constans.ExpandConstant;
import com.gingersoft.gsa.cloud.common.core.restaurant.utils.RestaurantExpandInfoUtils;
import com.gingersoft.gsa.cloud.common.core.table.TableBean;
import com.gingersoft.gsa.cloud.common.logan.LoganManager;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.common.utils.toast.ToastUtils;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.gingersoft.gsa.cloud.order.billItem.BillItem;
import com.gingersoft.gsa.cloud.order.cart.ShoppingCart;
import com.gingersoft.gsa.cloud.order.commodity.OrderDetail;
import com.gingersoft.gsa.cloud.order.order.DoshokuOrder;
import com.gingersoft.gsa.cloud.print.bean.PrintSlipContent;
import com.gingersoft.gsa.cloud.print.bean.base.PrintBillItem;
import com.gingersoft.gsa.cloud.print.bean.base.PrintFoodItem;
import com.joe.print.R;
import com.joe.print.mvp.model.bean.BillingBean;
import com.joe.print.mvp.model.bean.HtmlLable;
import com.joe.print.mvp.print.common.HtmlContract;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.joe.print.mvp.print.common.HtmlContract.LABLE_COLUMN;
import static com.joe.print.mvp.print.common.HtmlContract.LABLE_DIV;
import static com.joe.print.mvp.print.common.HtmlContract.LABLE_P;

/**
 * 印單打印 已改新版
 */
public class PrintSlip extends PrinterRoot<PrintSlipContent> {

    private PrintSlipContent mPrintSlipContent;
    private final String TAG = getClass().getSimpleName();

    @Override
    protected void setPrintContent(PrintSlipContent printContent) {
        this.mPrintSlipContent = printContent;
    }

    @Override
    public Map<String, List<Bitmap>> getPrintBitmap(Context mContext, PrinterDeviceBean deviceBean) {
        Map<String, List<Bitmap>> bitmapMaps = new HashMap<>();
        List<Bitmap> bitmaps = new ArrayList<>();
        Bitmap bitmap = getBitmap(mContext, deviceBean);
        if (bitmap != null) {
            bitmaps.add(getBitmap(mContext, deviceBean));
            bitmapMaps.put("", bitmaps);
        } else {
            return null;
        }
        //這裡可能還需要加上廚房單的內容，有未送單的食品時。
//        PrintKitchen kitchen = new PrintKitchen();
//        Map<String, List<Bitmap>> bitmapMaps = new HashMap<>(kitchen.getPrintBitmap(mContext, deviceBean));
//        if (bitmapMaps.size() == 0) {
//            bitmapMaps.put("", bitmaps);
//        } else {
//            merge2ResultMap(bitmapMaps, "", bitmaps);
//        }
        return bitmapMaps;
    }

    @Override
    public String[] getPrintDatas(Context mContext, PrinterDeviceBean deviceBean) {

        if (mPrintSlipContent == null) {
            return new String[]{"<html><body></body></html>"};
        }

        List<PrintFoodItem> foodList = mPrintSlipContent.getFoodItemList();

        if (foodList.size() == 0) {
            return new String[]{"<html><body></body></html>"};
        }

        String stringBuilder = "<html><body>" +
//                getHtmlPrintHeadInfo() +
//                getHtmlPrintHeadOrderInfo(tableBean) +
//                generateHtmlFoodInfo(foodList) +
//                getHtmlBillInfo() +
//                getWholeLine() +
//                getHtmlFooter() +
                getHtmlContent(deviceBean) +
                "</body></html>";

        int printCount = getPrintCount(mContext);
        String[] pritContent = new String[printCount];
        for (int i = 0; i < printCount; i++) {
            pritContent[i] = stringBuilder;
        }
        return pritContent;
    }

    private String getHtmlContent(PrinterDeviceBean deviceBean) {

        List<HtmlLable> htmlLables = new ArrayList<>();

        /**
         * 頭部
         */
        htmlLables.add(new HtmlLable(LABLE_DIV, mPrintSlipContent.getBrand(),
                new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_ALIGN, HtmlContract.value_align_center, HtmlContract.value_type_string),
                new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_FONT_SIZE, "28")));
        htmlLables.add(new HtmlLable(LABLE_DIV, mPrintSlipContent.getResturantName(),
                new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_ALIGN, HtmlContract.value_align_center, HtmlContract.value_type_string),
                new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_FONT_SIZE, "28")));
        htmlLables.add(new HtmlLable(LABLE_P, HtmlContract.dividing_line));
        /**
         * 訂單
         */
        String orderNum = "單號：";
        if (TextUtil.isNotEmptyOrNullOrUndefined(mPrintSlipContent.getOrderNo())) {
            orderNum = "單號：" + mPrintSlipContent.getOrderNo();
        }
        htmlLables.addAll(getRowInformation(new HtmlLable[]{new HtmlLable(LABLE_COLUMN, "餐檯：" + mPrintSlipContent.getTableName())}, 24));
        htmlLables.addAll(getRowInformation(new HtmlLable[]{new HtmlLable(LABLE_COLUMN, "人數：" + mPrintSlipContent.getPerson())}, 24));
        htmlLables.addAll(getRowInformation(new HtmlLable[]{new HtmlLable(LABLE_COLUMN, orderNum)}, 24));
        htmlLables.addAll(getRowInformation(new HtmlLable[]{new HtmlLable(LABLE_COLUMN, "日期：" + TimeUtils.parseTimeRepeat(mPrintSlipContent.getCreateTime(), TimeUtils.DEFAULT_DATE_FORMAT))}, 24));
        htmlLables.add(new HtmlLable(LABLE_P, HtmlContract.dividing_line));
        /**
         * 食品
         */
        if (mPrintSlipContent.getFoodItemList() != null && mPrintSlipContent.getFoodItemList().size() > 0) {
            htmlLables.addAll(getBBPosFoodLineString(mPrintSlipContent.getFoodItemList(), deviceBean));
            htmlLables.add(new HtmlLable(LABLE_P, HtmlContract.dividing_line));
        }
        /**
         * 合計、賬單項、總金額
         */
        //合計
        htmlLables.addAll(getRowInformation(new HtmlLable[]{
                new HtmlLable(LABLE_COLUMN, "合計:"),
                new HtmlLable(LABLE_COLUMN, AppConstans.CARSH_STR + mPrintSlipContent.getWholeAmount(), new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_OFFSET, HtmlContract.value_offset_last))}, 28));

        List<PrintBillItem> billItemList = mPrintSlipContent.getBillItemList();
        if (billItemList.size() > 0) {
            for (PrintBillItem billItem : billItemList) {
                htmlLables.addAll(getRowInformation(new HtmlLable[]{
                        new HtmlLable(LABLE_COLUMN, billItem.getBillName()),
                        new HtmlLable(LABLE_COLUMN, billItem.getBillAmount(), new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_OFFSET, HtmlContract.value_offset_last))}, 28));
            }
            htmlLables.add(new HtmlLable(LABLE_P, HtmlContract.dividing_line));
        }
        //總金額
        htmlLables.addAll(getRowInformation(new HtmlLable[]{
                new HtmlLable(LABLE_COLUMN, "總金額:"),
                new HtmlLable(LABLE_COLUMN, AppConstans.CARSH_STR + mPrintSlipContent.getTotalAmount(), new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_OFFSET, HtmlContract.value_offset_last))}, 35));
        htmlLables.add(new HtmlLable(LABLE_P, HtmlContract.dividing_line));

        /**
         * 底部
         */
        htmlLables.add(new HtmlLable(LABLE_DIV, mPrintSlipContent.getPoliteLanguage(),
                new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_ALIGN, HtmlContract.value_align_center, HtmlContract.value_type_string),
                new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_FONT_SIZE, "24")));

        htmlLables.add(new HtmlLable(LABLE_DIV, TimeUtils.getCurrentTimeInString(TimeUtils.DEFAULT_DATE_FORMAT),
                new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_ALIGN, HtmlContract.value_align_center, HtmlContract.value_type_string),
                new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_FONT_SIZE, "24")));

        return getHtmlLables(htmlLables.toArray(new HtmlLable[htmlLables.size()]));

    }

    private String getPLable(String content) {
        return "<p>" + content + "</p>";
    }

    @Override
    public int getPrintCount(Context context) {
        return RestaurantExpandInfoUtils.getValue(ExpandConstant.TableModePrintCount, 1);
    }

    private Bitmap getBitmap(Context mContext, PrinterDeviceBean printerDeviceBean) {

        List<PrintFoodItem> foodList = mPrintSlipContent.getFoodItemList();
        if (foodList == null || foodList.size() <= 0) {
            LoganManager.w_printer(TAG, "生成打印數據失敗，印單沒有食品");
            return null;
        }

        LinearLayout layout = new LinearLayout(mContext);
        layout.setOrientation(LinearLayout.VERTICAL);

        //訂單頭
        layout.addView(getHeader(mContext));
        layout.addView(getLine(mContext));

        //訂單信息
        layout.addView(getDiningTableOrderInfo(mContext, "餐檯：" + mPrintSlipContent.getTableName(), "人數：" + mPrintSlipContent.getPerson(), "單號：" + mPrintSlipContent.getOrderNo(), "日期：" + TimeUtils.getCurrentTimeInString(TimeUtils.DEFAULT_DATE_FORMAT)));
        layout.addView(getLine(mContext));

        layout.addView(getDiningFoodList(mContext, foodList, printerDeviceBean, 0, true));
        layout.addView(getHalfLine(mContext));
        List<BillingBean> billingBeans = new ArrayList<>();

        //添加合計項
        billingBeans.add(new BillingBean("合計", mPrintSlipContent.getWholeAmount()));
        //添加其他金額項
        if (mPrintSlipContent.getBillItemList().size() > 0) {
            for (PrintBillItem item : mPrintSlipContent.getBillItemList()) {
                billingBeans.add(new BillingBean(item.getBillName(), Double.parseDouble(item.getBillAmount())));
            }
        }
        layout.addView(getDiningBillInfo(mContext, billingBeans));
        layout.addView(getHalfLine(mContext));
        layout.addView(getAmountText(mContext, "總金額：" + mPrintSlipContent.getTotalAmount()));
        layout.addView(getLine(mContext));
        layout.addView(getTextView(mContext, "Thank you!", Gravity.CENTER_HORIZONTAL, getDimensionPixelSize(mContext, R.dimen.dp_8)));
        layout.addView(getTextView(mContext, TimeUtils.getCurrentTimeInString(TimeUtils.DEFAULT_DATE_FORMAT), Gravity.CENTER_HORIZONTAL, getDimensionPixelSize(mContext, R.dimen.dp_8)));
        return viewToZoomBitmap(mContext, layout, printerDeviceBean);
    }


}
