package com.joe.print.mvp.ui.view;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;

import com.airbnb.lottie.LottieAnimationView;
import com.gingersoft.gsa.cloud.ui.widget.dialog.BaseRetryDialog;
import com.joe.print.R;
import com.qmuiteam.qmui.layout.QMUILinearLayout;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-03-28
 * 修订历史：2020-03-28
 * 描述：
 */
public class PrinterLoadingDialog extends BaseRetryDialog {

    private static final String TAG = "PrinterLoadingDialog";

    private Context mContext;

    private TextView tv_generate_print_data, tv_connecting, tv_printing, tv_print_result;

//    @BindDrawable(R.drawable.print_grey_point)
//    Drawable mGreyDrawable;
//    @BindDrawable(R.drawable.print_green_point)
//    Drawable mGreedDrawable;
//    @BindDrawable(R.drawable.print_red_point)
//    Drawable mReaDrawable;

    public static final byte status_default = 0;
    public static final byte status_success = 1;
    public static final byte status_error = 2;

    private int mRadius;
    private float mShadowAlpha = 0.25f;
    private int mShadowElevationDp = 14;

    public PrinterLoadingDialog(@NonNull Context context) {
        super(context, R.style.MyDialogTheme2);
        mContext = context;
        mRadius = QMUIDisplayHelper.dp2px(mContext, 8);
        drawables = new Drawable[3];
        drawables[0] = getDrawableByResId(R.drawable.print_grey_point);
        drawables[1] = getDrawableByResId(R.drawable.print_green_point);
        drawables[2] = getDrawableByResId(R.drawable.print_red_point);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setCanceledOnTouchOutside(true);
    }

    @Override
    public void show() {
        super.show();
    }

    @Override
    public void dismiss() {
        super.dismiss();
    }

    public PrinterLoadingDialog build() {
        View contentView = buildViews();
        int screenWidth = (int) (QMUIDisplayHelper.getScreenWidth(mContext) * 0.9);
        int screenHeight = (int) (QMUIDisplayHelper.getScreenHeight(mContext) * 0.5);
        setContentView(contentView, new LinearLayout.LayoutParams(screenWidth, screenHeight));
        return this;
    }

    private View buildViews() {
        View view = View.inflate(mContext, getContentViewLayoutId(), null);
        QMUILinearLayout ll_container = view.findViewById(R.id.ll_container);
        LottieAnimationView printLottieView = view.findViewById(R.id.lottieAnimationView);
        tv_generate_print_data = view.findViewById(R.id.tv_generate_print_data);
        tv_connecting = view.findViewById(R.id.tv_connecting);
        tv_printing = view.findViewById(R.id.tv_printing);
        tv_print_result = view.findViewById(R.id.tv_print_result);

        textViews = new TextView[]{tv_generate_print_data, tv_connecting, tv_printing, tv_print_result};
        ll_container.setRadiusAndShadow(mRadius, QMUIDisplayHelper.dp2px(mContext, mShadowElevationDp), mShadowAlpha);

        printLottieView.setAnimation(R.raw.printer_loading3);
        printLottieView.setRepeatCount(ValueAnimator.INFINITE);
//        printLottieView.addAnimatorUpdateListener((animation) -> {
//            // Do something.动画状态监听回调
//        });
        printLottieView.playAnimation();//播放动画
//        //progress范围0~1f，设置动画进度
//        printLottieView.setProgress(0.5f);
//        // 自定义动画时长，此处利用ValueAnimator值动画来实时更新AnimationView的进度来达到控制动画时长。
//        ValueAnimator animator = ValueAnimator.ofFloat(0f, 1f).setDuration(500);
//        animator.start();//启动动画
        return view;
    }

    private Drawable[] drawables;
    private TextView[] textViews;

    public void setStep(int step, int status) {
        tv_generate_print_data.post(() -> setCompoundDrawableByStatus(status, textViews[step - 1]));
    }

    private void setCompoundDrawableByStatus(int status, TextView textView) {
        textView.setCompoundDrawablesWithIntrinsicBounds(textView.getCompoundDrawables()[0], drawables[status], textView.getCompoundDrawables()[2], textView.getCompoundDrawables()[0]);

    }

    private Drawable getDrawableByResId(int resId) {
        return ContextCompat.getDrawable(mContext, resId);
    }

    protected int getContentViewLayoutId() {
        return R.layout.print_dialog_loading;
    }
}
