package com.gingersoft.supply_chain.mvp.ui.fragment.order;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.viewpager2.widget.ViewPager2;

import com.gingersoft.gsa.cloud.ui.utils.AppDialog;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.di.component.DaggerPurchaseListComponent;
import com.gingersoft.supply_chain.mvp.bean.OrderBean;
import com.gingersoft.supply_chain.mvp.content.SupplyShoppingCart;
import com.gingersoft.supply_chain.mvp.contract.PurchaseListContract;
import com.gingersoft.supply_chain.mvp.presenter.PurchaseListPresenter;
import com.gingersoft.supply_chain.mvp.ui.adapter.PurchaseOrderAdapter;
import com.gingersoft.supply_chain.mvp.ui.adapter.PurchasePageAdapter;
import com.gingersoft.supply_chain.mvp.ui.fragment.BaseSupplyChainFragment;
import com.gingersoft.supply_chain.mvp.ui.fragment.food.FoodIngredientsFragment;
import com.gingersoft.supply_chain.mvp.ui.widget.ScreenView;
import com.jess.arms.di.component.AppComponent;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.widget.QMUITopBar;
import com.qmuiteam.qmui.widget.tab.QMUIBasicTabSegment;
import com.qmuiteam.qmui.widget.tab.QMUITabBuilder;
import com.qmuiteam.qmui.widget.tab.QMUITabIndicator;
import com.qmuiteam.qmui.widget.tab.QMUITabSegment;
import com.qmuiteam.qmui.widget.tab.QMUITabSegment2;

import java.util.List;

import butterknife.BindView;
import butterknife.OnClick;

import static com.gingersoft.supply_chain.mvp.ui.fragment.food.FoodIngredientsFragment.ADD_ORDER;


/**
 * Description:採購單列表
 */
public class PurchaseListFragment extends BaseSupplyChainFragment<PurchaseListPresenter> implements PurchaseListContract.View, View.OnClickListener {

    @BindView(R2.id.topbar_purchase_list)
    QMUITopBar mTopBar;
    @BindView(R2.id.purchase_list_tabSegment)
    QMUITabSegment2 mTabSegment;
    @BindView(R2.id.contentViewPager)
    ViewPager2 contentViewPager;
    @BindView(R2.id.btn_save)
    QMUIAlphaButton btnNewOrder;
    @BindView(R2.id.screen_view)
    ScreenView screenView;
    private PurchaseOrderAdapter purchaseOrderAdapter;


    public static PurchaseListFragment newInstance() {
        PurchaseListFragment fragment = new PurchaseListFragment();
        return fragment;
    }

    private final int[] orderState = new int[]{0, 1, 2, 3};
    private int pageIndex = 1;

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerPurchaseListComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_purchase_list, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        btnNewOrder.setText("+新增訂單");
        btnNewOrder.setOnClickListener(v -> {
            //跳轉到下單頁面
            start(FoodIngredientsFragment.newInstance(ADD_ORDER));
        });
        initTopBar();
        initTabAndData();
        mPresenter.getOrderList("", orderState[0], pageIndex);
    }

    @Override
    public void onSupportVisible() {
        super.onSupportVisible();
        if (tvCartGoodsNum != null) {
            tvCartGoodsNum.setText(String.valueOf(SupplyShoppingCart.getInstance().getCartFoods().size()));
        }
    }

    private TextView tvCartGoodsNum;

    private void initTopBar() {
        mTopBar.addLeftBackImageButton().setOnClickListener(v -> killMyself());
        mTopBar.setTitle("採購列表");
        View view = View.inflate(mContext, R.layout.layout_shopping_cart, null);
        tvCartGoodsNum = view.findViewById(R.id.tv_purchase_cart_size);
        tvCartGoodsNum.setText(String.valueOf(SupplyShoppingCart.getInstance().getCartFoods().size()));

        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.MATCH_PARENT);
        mTopBar.addRightView(view, R.id.qmui_shopping_cart, layoutParams);
        view.setOnClickListener(v -> start(ShoppingCatFragment.newInstance()));
    }

    private void initTabAndData() {
        QMUITabBuilder builder = mTabSegment.tabBuilder()
                .setNormalColor(ContextCompat.getColor(mContext, R.color.color_86))
                .setSelectColor(ContextCompat.getColor(mContext, R.color.theme_color));

        purchaseOrderAdapter = new PurchaseOrderAdapter(null);
        purchaseOrderAdapter.setOnItemClickListener((adapter, view, position) -> start(OrderDetailsFragment.newInstance(purchaseOrderAdapter.getData().get(position).getId())));
        purchaseOrderAdapter.setOnItemChildClickListener((adapter, view, position) -> {
            int viewId = view.getId();
            if (viewId == R.id.iv_supplier_delete) {
                //刪除採購單
                AppDialog.getInstance().showWaringDialog(mContext, "是否刪除採購單?", (view1, dialog) -> {
                    List<OrderBean> data = purchaseOrderAdapter.getData();
                    mPresenter.deleteOrder(position, data.get(position));
                    dialog.dismiss();
                });
            }
        });
        PurchasePageAdapter adapter = new PurchasePageAdapter(purchaseOrderAdapter, 4);
        contentViewPager.setAdapter(adapter);
        mTabSegment.setupWithViewPager(contentViewPager);
        mTabSegment.setIndicator(new QMUITabIndicator(
                QMUIDisplayHelper.dp2px(getContext(), 2), false, false));
        mTabSegment.addTab(builder.setText("全部").build(getContext())).getSelectedIndex();
        mTabSegment.addTab(builder.setText("待收貨").build(getContext()));
        mTabSegment.addTab(builder.setText("部分收貨").build(getContext()));
        mTabSegment.addTab(builder.setText("全部收貨").build(getContext()));
        mTabSegment.notifyDataChanged();
        mTabSegment.setMode(QMUITabSegment.MODE_FIXED);
        mTabSegment.addOnTabSelectedListener(new QMUIBasicTabSegment.OnTabSelectedListener() {
            @Override
            public void onTabSelected(int index) {
                mPresenter.getOrderList("", orderState[index], pageIndex);
            }

            @Override
            public void onTabUnselected(int index) {

            }

            @Override
            public void onTabReselected(int index) {

            }

            @Override
            public void onDoubleTap(int index) {
                mTabSegment.clearSignCountView(index);
            }
        });
    }

    @OnClick({R2.id.layout_purchase_list_screen})
    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.layout_purchase_list_screen) {
            //篩選
            screenView.setVisibility(screenView.getVisibility() == View.VISIBLE ? View.GONE : View.VISIBLE);
        }
    }

    @Override
    public void loadOrderList(List<OrderBean> list) {
        purchaseOrderAdapter.setList(list);
    }

    @Override
    public void deleteOrder(int position) {
        purchaseOrderAdapter.removeAt(position);
    }
}
