package com.gingersoft.gsa.cloud.order.bean.event;

import android.os.Parcel;
import android.os.Parcelable;

import com.gingersoft.gsa.cloud.common.core.table.TableBean;
import com.gingersoft.gsa.cloud.order.bean.request.MealOrderPayRequest;
import com.gingersoft.gsa.cloud.order.billItem.BillItem;
import com.gingersoft.gsa.cloud.pay.bean.PayMethod;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.pos.SaleRespose;
import java.util.List;
import lombok.Data;

/**
 * @作者: bin
 * @創建時間: 2020-12-28 18:17
 * @更新時間: 2020-12-28 18:17
 * @描述:
 */
@Data
public class MealPayResultParam implements Parcelable {

    private TableBean.DataBean tableBean;
    private MealOrderPayRequest mealOrderPayRequest;
    private List<BillItem> billItemList;
    private List<PayMethod> payMethodList;

    private SaleRespose saleRespose;
    private String txnId;

    public MealPayResultParam() {
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.tableBean, flags);
        dest.writeParcelable(this.mealOrderPayRequest, flags);
        dest.writeTypedList(this.billItemList);
        dest.writeTypedList(this.payMethodList);
        dest.writeParcelable(this.saleRespose, flags);
        dest.writeString(this.txnId);
    }

    protected MealPayResultParam(Parcel in) {
        this.tableBean = in.readParcelable(TableBean.DataBean.class.getClassLoader());
        this.mealOrderPayRequest = in.readParcelable(MealOrderPayRequest.class.getClassLoader());
        this.billItemList = in.createTypedArrayList(BillItem.CREATOR);
        this.payMethodList = in.createTypedArrayList(PayMethod.CREATOR);
        this.saleRespose = in.readParcelable(SaleRespose.class.getClassLoader());
        this.txnId = in.readString();
    }

    public static final Creator<MealPayResultParam> CREATOR = new Creator<MealPayResultParam>() {
        @Override
        public MealPayResultParam createFromParcel(Parcel source) {
            return new MealPayResultParam(source);
        }

        @Override
        public MealPayResultParam[] newArray(int size) {
            return new MealPayResultParam[size];
        }
    };
}
