package com.gingersoft.gsa.cloud.pay.pos.hywebpos.imp;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.constans.HttpsConstans;
import com.gingersoft.gsa.cloud.common.utils.gson.GsonUtils;
import com.gingersoft.gsa.cloud.common.utils.okhttpUtils.OkHttp3Utils;
import com.gingersoft.gsa.cloud.pay.contract.PayErrorCode;
import com.gingersoft.gsa.cloud.pay.pos.IPosAction;
import com.gingersoft.gsa.cloud.pay.pos.OnPosActionListener;
import com.gingersoft.gsa.cloud.pay.pos.PosAction;
import com.gingersoft.gsa.cloud.pay.pos.bean.PosMatter;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.request.bg.GetTxnIdRequest;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.request.pos.AdjustTipRequest;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.bg.GetTipTxnIdResponse;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.pos.AdjustTipRespose;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.pos.HywebPosResponse;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.constant.PayStatusCode;
import com.jess.arms.integration.AppManager;
import com.jess.arms.mvp.IView;
import com.jess.arms.utils.ArmsUtils;
import com.jess.arms.utils.RxLifecycleUtils;

import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import okhttp3.MediaType;
import okhttp3.RequestBody;

/**
 * @作者: bin
 * @創建時間: 2020-12-26 10:38
 * @更新時間: 2020-12-26 10:38
 * @描述:
 */
public class TipsActionImpl extends IPosAction {


    private AdjustTipRequest mAdjustTipRequest;

    private GetTxnIdRequest mTxnIdRequest;
    private GetTipTxnIdResponse mTxnIdResponse;

    private OnPosActionListener mOnPosActionListener;

    public TipsActionImpl(Context context, IView iView, PosAction action, GetTxnIdRequest txnIdRequest, AdjustTipRequest adjustTipRequest, OnPosActionListener onPosActionListener, boolean showLoading) {
        super(context, iView, action, showLoading);
        this.mTxnIdRequest = txnIdRequest;
        this.mAdjustTipRequest = adjustTipRequest;
        this.mOnPosActionListener = onPosActionListener;
    }

    @Override
    protected void onRequestBefore() {

        RequestBody requestBody = RequestBody.create(MediaType.parse("application/json"), GsonUtils.GsonString(mTxnIdRequest));
        String json = GsonUtils.GsonString(mTxnIdRequest);

        OkHttp3Utils.post(HttpsConstans.ROOT_SERVER_ADDRESS_FORMAL + "posPay/getTipTxnId", requestBody)
                .subscribeOn(Schedulers.io())
                .observeOn(Schedulers.io())
                .doOnSubscribe(disposable -> {

                })
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Observer<String>() {

                    @Override
                    public void onSubscribe(Disposable d) {
                    }

                    @Override
                    public void onNext(String result) {
                        String error = "調起補小費異常";
                        if (!TextUtils.isEmpty(result)) {
                            BaseResult baseResult = GsonUtils.GsonToBean(result, BaseResult.class);
                            if (baseResult != null) {
                                if (baseResult.isSuccess() && baseResult.getData() != null) {
                                    mTxnIdResponse = GsonUtils.GsonToBean(baseResult.getData(), GetTipTxnIdResponse.class);
                                    if (mAdjustTipRequest != null) {
                                        mAdjustTipRequest.setTXN_ID(mTxnIdResponse.getTipTxnId());
                                        //調起N5補小費
                                        onRequestPOS(GsonUtils.GsonString(mAdjustTipRequest));
                                        canCelLoadingDialog();
                                    } else {
                                        onActionError(new Exception(error + PayErrorCode.tips_701));
                                    }
                                } else {
                                    if (!TextUtils.isEmpty(baseResult.getErrMsg())) {
                                        onActionError(new Exception(baseResult.getErrMsg()));
                                    } else {
                                        onActionError(new Exception(error + PayErrorCode.tips_702));
                                    }
                                }
                            } else {
                                onActionError(new Exception(error + PayErrorCode.tips_703));
                            }
                        } else {
                            onActionError(new Exception(error + PayErrorCode.tips_704));
                        }
                    }

                    @Override
                    public void onComplete() {
                    }

                    @Override
                    public void onError(Throwable t) {
                        onActionError(new Exception(t.getMessage()));
                    }
                });
    }

    /**
     * 補小費回調成功
     * 1、更新上傳小費狀態
     * 2、顯示小費結果
     * 3、刷新當前頁面
     *
     * @param context
     * @param response
     * @param originalActivity
     */
    @Override
    public void onActionComplte(Context context, HywebPosResponse response, Activity originalActivity) {

        if (mOnPosActionListener != null) {
            mOnPosActionListener.onPosSuccess(response);
        }

        //1、更新上傳小費狀態
        OkHttp3Utils.post(HttpsConstans.ROOT_SERVER_ADDRESS_FORMAL + "orderPay/updatePosTip", getPosMatterRequest((AdjustTipRespose) response))
                .subscribeOn(Schedulers.io())
                .observeOn(Schedulers.io())
                .doOnSubscribe(disposable -> {
                })
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> {

                })
                .compose(RxLifecycleUtils.bindToLifecycle(mView))
                .subscribe(new Observer<String>() {

                    @Override
                    public void onSubscribe(Disposable d) {
                    }

                    @Override
                    public void onNext(String result) {

                        showTipsResult(context, response, originalActivity);

                        if (!TextUtils.isEmpty(result)) {
                            BaseResult baseResult = GsonUtils.GsonToBean(result, BaseResult.class);
                            if (baseResult != null) {
                                if (baseResult.isSuccess() && baseResult.getData() != null) {
                                    if (mOnPosActionListener != null) {
                                        mOnPosActionListener.onSuccess(response);
                                    }
                                } else {
                                    onActionError(new Exception(mPosAction.getCallbackExceptionText() + PayErrorCode.tips_711));
                                }
                            } else {
                                onActionError(new Exception(mPosAction.getCallbackExceptionText() + PayErrorCode.tips_712));
                            }
                        } else {
                            onActionError(new Exception(mPosAction.getCallbackExceptionText() + PayErrorCode.tips_713));
                        }
                    }

                    @Override
                    public void onError(Throwable e) {
                        showTipsResult(context, response, originalActivity);
                        if (mOnPosActionListener != null) {
                            mOnPosActionListener.onError(e);
                        }
                    }

                    @Override
                    public void onComplete() {
                    }
                });
    }

    /**
     * 2、顯示小費結果
     *
     * @param context
     * @param response
     * @param originalActivity
     */
    private void showTipsResult(Context context, HywebPosResponse response, Activity originalActivity) {
        if (PayStatusCode.withSuccess(response.getSTATUS())) {
            //補小費成功
            AppManager appManager = ArmsUtils.obtainAppComponentFromContext(context).appManager();
            Activity activity = appManager.getCurrentActivity();
            if (activity.getClass().equals(originalActivity.getClass())) {
                super.onActionComplte(context, response, originalActivity);
            }
        } else {
            //補小費失敗
            onActionError(new Exception(mPosAction.getActionName() + PayStatusCode.getHywebRequestTextByCode(response.getSTATUS()) + PayErrorCode.tips_710));
        }
    }

    private RequestBody getPosMatterRequest(AdjustTipRespose response) {

        PosMatter posMatter = new PosMatter();
        posMatter.setOrderId(mTxnIdRequest.getOrderId());
        posMatter.setTipsPrice(mTxnIdRequest.getTipsPrice());
        posMatter.setPayId(response.getTXN_ID());
        posMatter.setContent(GsonUtils.GsonString(response));
        posMatter.setStatus(getPosMatterStatus(response.getSTATUS()));

        RequestBody requestBody = RequestBody.create(MediaType.parse("application/json"), GsonUtils.GsonString(posMatter));
        String json = GsonUtils.GsonString(posMatter);

        return requestBody;
    }


}
