package com.gingersoft.gsa.cloud.ui.adapter.multi;

import com.chad.library.adapter.base.provider.BaseItemProvider;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.ui.R;
import com.gingersoft.gsa.cloud.ui.bean.InfoMultiBean;

import org.jetbrains.annotations.NotNull;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/20
 * Time: 11:07
 * Use:
 */
public abstract class MyBaseItemProvider extends BaseItemProvider<InfoMultiBean> {

    @Override
    public void convert(@NotNull BaseViewHolder baseViewHolder, InfoMultiBean infoMultiBean) {
        //是否顯示必選
        baseViewHolder.setGone(R.id.multi_required, !infoMultiBean.isRequired());
        //設置標題
        if (TextUtil.isNotEmptyOrNullOrUndefined(infoMultiBean.getShowTitle())) {
            baseViewHolder.setText(R.id.tv_multi_title, infoMultiBean.getShowTitle());
        } else {
            baseViewHolder.setText(R.id.tv_multi_title, "");
        }
    }
}
