package com.gingersoft.gsa.cloud.ui.adapter.multi;

import android.text.Editable;
import android.text.TextWatcher;
import android.widget.EditText;
import android.widget.TextView;

import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.ui.R;
import com.gingersoft.gsa.cloud.ui.bean.InfoMultiBean;
import com.gingersoft.gsa.cloud.ui.bean.MultiInputBean;

import org.jetbrains.annotations.NotNull;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/10/29
 * Time: 15:58
 * Use: 備註輸入框樣式
 */
public class RemarkProvider<T extends InfoMultiBean> extends InputProvider<T> {
    public final static int REMARK_TEXT_LENGTH = 100;

    @Override
    public int getItemViewType() {
        return InfoMultiBean.ITEM_MULTIPLE_INPUT_REMARK;
    }

    @Override
    public int getLayoutId() {
        return R.layout.multi_input_remark;
    }

    @Override
    public void convert(@NotNull BaseViewHolder baseViewHolder, T t) {
        MultiInputBean infoMultiBean = (MultiInputBean) t;

        EditText editText = baseViewHolder.getView(R.id.ed_multi_value);
        baseViewHolder.setGone(R.id.tv_edit_text_length, infoMultiBean.getMaxLength() <= 0);
        TextView tvEditLength = baseViewHolder.getView(R.id.tv_edit_text_length);

        if (infoMultiBean.getMaxLength() > 0) {
            tvEditLength.setText(editText.getText().length() + "/" + infoMultiBean.getMaxLength());
        }
        if (TextUtil.isNotEmptyOrNullOrUndefined(infoMultiBean.getShowValue())) {
            editText.setText(infoMultiBean.getShowValue());
        } else {
            editText.setHint(infoMultiBean.getHintText());
            editText.setText("");
        }
        editText.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                if (s != null) {
                    int textLength = TextUtil.getStringLength(s.toString());
                    tvEditLength.setText(textLength + "/" + infoMultiBean.getMaxLength());
                }
            }
        });
    }
}

