package com.gingersoft.gsa.cloud.table.mvp.contract;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.core.table.TableBean;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.response.BaseOrderResponse;
import com.gingersoft.gsa.cloud.table.mvp.action.table.TableAction;
import com.gingersoft.gsa.cloud.table.mvp.ui.fragment.AllTableFragment;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.mvp.IModel;
import com.jess.arms.mvp.IView;

import java.util.List;

import io.reactivex.Observable;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/27/2019 19:19
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public interface TableContract {
    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends IView {

        void loadState(Class<?> c);

        void returnTableList(List<TableBean.DataBean> dataBeanList);

        AllTableFragment getCurrentTableFragment();

        void clickTableItem(TableBean.DataBean dataBean);

        void onStartRefreshTableData();

        void onPauseRefreshTableData();

        void setBottomFunctionAdapter(DefaultAdapter adapter);

        void setBottomFunctionRecycleLayoutManager(int orientation);

        void setCurrentTableAction(TableAction action);

        void setTableActionContentText(String contentText);

        String getOperatContentText();

        void setTableActionTitle(TableAction action);

        void canceTableAction();

        void startMealStandActivity();

        void setBottomFunctionVisibility(boolean show);

        void setLockVisibility(boolean show);

        void setCenterContentMarginBottom(int bottomMargin);
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends IModel {

        List<Food> queryDB_AllFoodList();

        List<Modifier> queryDB_ModifierList(long fid, int mode);

        Observable<TableBean> getTables(int restaurantId);

        Observable<BaseResult> getTable(int tableId, String tableNumber);

        Observable<BaseOrderResponse> getOrderById(long orderId);

        Observable<BaseOrderResponse> openTable(RequestBody requestBody);

        Observable<BaseOrderResponse> turnTable(RequestBody requestBody);

        Observable<BaseOrderResponse> initTable(RequestBody requestBody);

        Observable<BaseResult> resetSkyorder(RequestBody requestBody);

        Observable<BaseResult> getSplitTables(int tableId);

        Observable<BaseResult> splitTable(int tableId);

        Observable<BaseResult> getFoodSummarys(int restaurantId,boolean isDefault, byte businessType);

        Observable<BaseResult> addScan(RequestBody requestBody);
    }
}
