package com.gingersoft.gsa.cloud.login.mvp.ui.activity;

import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.ScaleAnimation;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.viewpager2.widget.ViewPager2;

import com.billy.cc.core.component.CC;
import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.bean.BaseResultOld;
import com.gingersoft.gsa.cloud.common.core.login.LoginBean;
import com.gingersoft.gsa.cloud.common.core.restaurant.RestaurantInfoManager;
import com.gingersoft.gsa.cloud.common.core.user.UserConstans;
import com.gingersoft.gsa.cloud.common.core.user.UserContext;
import com.gingersoft.gsa.cloud.common.core.user.state.LoginedState;
import com.gingersoft.gsa.cloud.common.utils.encryption.Aes;
import com.gingersoft.gsa.cloud.common.utils.other.SPUtils;
import com.gingersoft.gsa.cloud.login.R;
import com.gingersoft.gsa.cloud.login.R2;
import com.gingersoft.gsa.cloud.login.di.component.DaggerWelcomeComponent;
import com.gingersoft.gsa.cloud.login.di.module.WelcomeModule;
import com.gingersoft.gsa.cloud.login.mvp.bean.GuideBean;
import com.gingersoft.gsa.cloud.login.mvp.contract.LoginInterfaceImpl;
import com.gingersoft.gsa.cloud.login.mvp.contract.WelcomeContract;
import com.gingersoft.gsa.cloud.login.mvp.presenter.WelcomePresenter;
import com.gingersoft.gsa.cloud.login.mvp.ui.activity.ChooseRestaurantActivity;
import com.gingersoft.gsa.cloud.login.mvp.ui.adapter.GuideAdapter;
import com.gingersoft.gsa.cloud.ui.widget.Indicator.UIndicator;
import com.gyf.immersionbar.ImmersionBar;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.jess.arms.utils.StatusBarUtil;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.util.QMUIStatusBarHelper;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.OnClick;

import static com.jess.arms.utils.Preconditions.checkNotNull;


public class WelcomeActivity extends LoginInterfaceImpl<WelcomePresenter> implements WelcomeContract.View, View.OnClickListener {
    @BindView(R2.id.content_view)
    RelativeLayout contentView;
    @BindView(R2.id.cl_guide_layout)
    ConstraintLayout guideView;
    @BindView(R2.id.vp2_guide)
    ViewPager2 mVpGuide;
    @BindView(R2.id.iv_guide_close)
    ImageView ivCloseGuide;
    @BindView(R2.id.guide_magic_indicator)
    UIndicator magicIndicator;

    @BindView(R2.id.tv_guide_title)
    TextView mTvGuideTitle;
    @BindView(R2.id.tv_guide_details)
    TextView mTvGuideDetails;
    @BindView(R2.id.tv_experience)
    TextView mTvExperience;
    List<GuideBean> guideBeanList = new ArrayList<>();
    private final long ANIMATION_TIME = 1300;

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerWelcomeComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .welcomeModule(new WelcomeModule(this))
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.activity_welcome; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    public void configImmersionBar(ImmersionBar immersionBar) {
        immersionBar.autoDarkModeEnable(true).statusBarDarkFont(true).init();
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        ScaleAnimation animation = new ScaleAnimation(1.0f, 1.06f, 1.0f, 1.06f, Animation.RELATIVE_TO_SELF, 0.5f, Animation.RELATIVE_TO_SELF, 0.5f);
        animation.setDuration(2000);
        animation.setFillAfter(true);
        contentView.setAnimation(animation);
        animation.setAnimationListener(new Animation.AnimationListener() {
            @Override
            public void onAnimationStart(Animation animation) {

            }

            @Override
            public void onAnimationEnd(Animation animation) {
                if ((boolean) SPUtils.get(UserConstans.IS_GUIDE, true)) {
                    //是第一次進入，顯示引導頁
                    showGuide();
                } else {
                    boolean isLogin = (boolean) SPUtils.get(UserConstans.AUTO_LOGIN, false);
                    if (isLogin) {
                        if (!TextUtils.isEmpty(UserContext.newInstance().getLoginToken()) && RestaurantInfoManager.newInstance().getRestaurantId() != 0) {
                            //自動登陸
                            UserContext.newInstance().setState(new LoginedState());
                            int restaurantId = RestaurantInfoManager.newInstance().getRestaurantId();
                            if (restaurantId > 0) {
                                //已经选择过餐厅 直接进入
//                                jumpDownloadActivity();
                                //需要驗證登陸人數
                                mPresenter.getLoginLimit(restaurantId, true);
                                return;
                            }
                            //调整选择餐厅页面
                            Intent intent = new Intent(mContext, ChooseRestaurantActivity.class);
                            Class clazz = WelcomeActivity.this.getClass();
                            intent.putExtra("form", clazz.getName());
                            launchActivity(intent);
                        } else {
                            startActivity(new Intent(mContext, com.gingersoft.gsa.cloud.login.mvp.ui.activity.mvp.ui.activity.LoginActivity.class));
                        }
                    } else {
                        startActivity(new Intent(mContext, com.gingersoft.gsa.cloud.login.mvp.ui.activity.mvp.ui.activity.LoginActivity.class));
                    }
                }
            }

            @Override
            public void onAnimationRepeat(Animation animation) {

            }
        });
        guideBeanList.add(new

                GuideBean("多終端雲同步，輕鬆管理所有", "為您搭建優良高效管理平台", getResources().

                getDrawable(R.mipmap.pic_guide_one)));
        guideBeanList.add(new

                GuideBean("數據分析可視化", "數據統計一目了然，直觀看到數據變化趨勢", getResources().

                getDrawable(R.mipmap.pic_guide_two)));
        guideBeanList.add(new

                GuideBean("多種點餐方式", "提供方便快捷的點餐服務，減低落錯單機會", getResources().

                getDrawable(R.mipmap.pic_guide_three)));
        GuideAdapter adapter = new GuideAdapter(mContext, guideBeanList);
        mVpGuide.setAdapter(adapter);
        //设置一个缩放动画
        mVpGuide.setPageTransformer(mAnimator);
        mVpGuide.registerOnPageChangeCallback(new ViewPager2.OnPageChangeCallback() {
            @Override
            public void onPageSelected(int position) {
                super.onPageSelected(position);

                updateUI(position);
                if (++position == guideBeanList.size() && mTvExperience.getVisibility() != View.VISIBLE) {
                    //當前選中最後一個page，顯示進入按鈕
                    mTvExperience.setVisibility(View.VISIBLE);
//                    mTvExperience.startAnimation(animation);
                }
            }
        });

        mVpGuide.setScrollBarFadeDuration((int) ANIMATION_TIME);
        magicIndicator.attachToViewPager(mVpGuide);
    }

    @Override
    protected void onStop() {
        super.onStop();
        killMyself();
    }

    private void updateUI(int position) {
        mTvGuideTitle.setText(guideBeanList.get(position).getTitle());
        mTvGuideDetails.setText(guideBeanList.get(position).getDetails());
        setAnimator();
    }

    private void setAnimator() {
        ObjectAnimator translationAnim = ObjectAnimator.ofFloat(mTvGuideTitle, "translationX", -120f, 0f);
        translationAnim.setDuration(ANIMATION_TIME);
        translationAnim.setInterpolator(new DecelerateInterpolator());

        ObjectAnimator translationAnim2 = ObjectAnimator.ofFloat(mTvGuideDetails, "translationX", -120f, 0f);
        translationAnim2.setDuration(ANIMATION_TIME);
        translationAnim2.setInterpolator(new DecelerateInterpolator());

        ObjectAnimator alphaAnimator = ObjectAnimator.ofFloat(mTvGuideTitle, "alpha", 0f, 1f);
        alphaAnimator.setDuration(ANIMATION_TIME);

        ObjectAnimator alphaAnimator1 = ObjectAnimator.ofFloat(mTvGuideDetails, "alpha", 0f, 1f);
        alphaAnimator1.setDuration(ANIMATION_TIME);

        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(translationAnim, alphaAnimator, translationAnim2, alphaAnimator1);
        animatorSet.start();
    }

    /**
     * 顯示引導圖
     */
    private void showGuide() {
        //重新設置一下狀態欄
        ImmersionBar.with(WelcomeActivity.this)
                .statusBarDarkFont(false)
                .titleBarMarginTop(ivCloseGuide)
                .navigationBarDarkIcon(false) //导航栏图标是深色，不写默认为亮色
                .init();
        Animation hideAnim = AnimationUtils.loadAnimation(mContext, R.anim.anim_alpha_hide);
        hideAnim.setAnimationListener(new Animation.AnimationListener() {
            @Override
            public void onAnimationStart(Animation animation) {
                guideView.startAnimation(AnimationUtils.loadAnimation(mContext, R.anim.anim_alpha_show));
                guideView.setVisibility(View.VISIBLE);
            }

            @Override
            public void onAnimationEnd(Animation animation) {
                contentView.setVisibility(View.GONE);
                guideView.setVisibility(View.VISIBLE);
            }

            @Override
            public void onAnimationRepeat(Animation animation) {

            }
        });
        contentView.startAnimation(hideAnim);
    }

    ViewPager2.PageTransformer mAnimator = (page, position) -> {
        Float absPos = Math.abs(position);
        Float scaleX;
        Float scaleY;
        if (absPos > 1) {
            scaleX = 0F;
            scaleY = 0F;
        } else {
            scaleX = 1 - absPos;
            scaleY = 1 - absPos;
        }
        page.setScaleX(scaleX);
        page.setScaleY(scaleY);
//        page.setRotationX(scaleX);
    };


    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {

    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }


    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(String message) {
        if (message != null) {
            checkNotNull(message);
            ArmsUtils.makeText(this, message);
        }
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }

    @Override
    public void loginSuccess(LoginBean info) {
        super.loginSuccess(info);
        finish();
    }

    @OnClick({R2.id.iv_guide_close, R2.id.tv_experience})
    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.iv_guide_close || v.getId() == R.id.tv_experience) {
            //去登陸頁，設置下次不顯示引導頁
            //立即體驗
            SPUtils.put(UserConstans.IS_GUIDE, false);
            startActivity(new Intent(mContext, com.gingersoft.gsa.cloud.login.mvp.ui.activity.mvp.ui.activity.LoginActivity.class));
        }
    }
}
