package com.gingersoft.supply_chain.mvp.ui.adapter.dishes;

import android.view.View;

import com.chad.library.adapter.base.entity.node.BaseNode;
import com.chad.library.adapter.base.provider.BaseNodeProvider;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.supply_chain.R;

import org.jetbrains.annotations.NotNull;

public class DishProvider extends BaseNodeProvider {
    @Override
    public int getItemViewType() {
        return DishesTreeAdapter.DISHESSINGLE;
    }

    @Override
    public int getLayoutId() {
        return R.layout.item_dishes;
    }

    @Override
    public void convert(@NotNull BaseViewHolder helper, @NotNull BaseNode data) {
        DishNode entity = (DishNode) data;
        helper.setText(R.id.tv_dish_title, entity.getTitle());

        if (entity.isExpanded()) {
            helper.setImageResource(R.id.iv_dishes_group_icon, R.mipmap.keyboard_delete_img);
        } else {
            helper.setImageResource(R.id.iv_dishes_group_icon, R.mipmap.keyboard_back_img);
        }
    }

    @Override
    public void onClick(@NotNull BaseViewHolder helper, @NotNull View view, BaseNode data, int position) {
        DishNode entity = (DishNode) data;
        if (entity.isExpanded()) {
            getAdapter().collapse(position);
        } else {
            getAdapter().expandAndCollapseOther(position);
        }
    }
}