package com.gingersoft.supply_chain.mvp.ui.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.chad.library.adapter.base.entity.node.BaseNode;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.di.component.DaggerDishesComponent;
import com.gingersoft.supply_chain.mvp.bean.BuyIngredientsBean;
import com.gingersoft.supply_chain.mvp.bean.DishesResultBean;
import com.gingersoft.supply_chain.mvp.contract.DishesContract;
import com.gingersoft.supply_chain.mvp.presenter.DishesPresenter;
import com.gingersoft.supply_chain.mvp.ui.adapter.dishes.DishNode;
import com.gingersoft.supply_chain.mvp.ui.adapter.dishes.DishesGroupNode;
import com.gingersoft.supply_chain.mvp.ui.adapter.dishes.DishesTreeAdapter;
import com.gingersoft.supply_chain.mvp.ui.widget.CenterLayoutManager;
import com.jess.arms.di.component.AppComponent;
import com.qmuiteam.qmui.widget.QMUITopBar;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;

/**
 * Created on 2021/07/21 14:28
 *
 * @author zjs
 * module name is DishesFragment
 */
public class DishesFragment extends BaseSupplyChainFragment<DishesPresenter> implements DishesContract.View {


    @BindView(R2.id.topbar_food_ingredients)
    QMUITopBar topbarFoodIngredients;
    @BindView(R2.id.rv_dishes)
    RecyclerView rvDishesGroup;
    @BindView(R2.id.rv_dishes_food)
    RecyclerView rvDishes;

    public static DishesFragment newInstance() {
        DishesFragment fragment = new DishesFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerDishesComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_dishes, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        //setToolBarNoBack(toolbar, "Dishes");
        initTopBar(topbarFoodIngredients, getString(R.string.str_dishes));
        mPresenter.getDishesData();
    }

    private void initDishes( List<DishesGroupNode> dishesGroupNodes){
        DishesTreeAdapter dishesTreeAdapter = new DishesTreeAdapter();
        dishesTreeAdapter.setList(dishesGroupNodes);
        rvDishes.setLayoutManager(new CenterLayoutManager(requireContext(), LinearLayoutManager.HORIZONTAL, false));
        rvDishes.setAdapter(dishesTreeAdapter);
    }

    private List<BaseNode> getEntity() {
        List<BaseNode> list = new ArrayList<>();
        for (int i = 0; i < 5; i++) {

            List<BaseNode> secondNodeList = new ArrayList<>();
            for (int n = 0; n <= 3; n++) {
                DishNode seNode = new DishNode(secondNodeList);
                secondNodeList.add(seNode);
            }

            DishesGroupNode entity = new DishesGroupNode(secondNodeList);

            // 模拟 默认第0个是展开的
            entity.setExpanded(i == 0);

            list.add(entity);
        }
        return list;
    }


    @Override
    public void loadDishGroupInfo( List<DishesGroupNode>   dishGroup) {
        initDishes(dishGroup);
    }

    @Override
    public void loadDishesInfo(DishesResultBean dishes) {

    }

    @Override
    public void loadFail() {

    }

    @Override
    public void finishLoad(boolean noData) {

    }

    @Override
    public void loadFood(List<BuyIngredientsBean> buyIngredientsBeans) {

    }

    @Override
    public void selectDishGroupByIndex(int position) {

    }
}