/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epos2.germanyfiscalelement;

import android.content.Context;
import android.util.Base64;
import com.epson.epos2.ConnectionListener;
import com.epson.epos2.Epos2Exception;
import com.epson.epos2.germanyfiscalelement.GermanyFiscalElementStatusInfo;
import com.epson.epos2.germanyfiscalelement.ReceiveListener;
import java.lang.reflect.Method;

public class GermanyFiscalElement {
    private long mGfeHandle = 0L;
    private Context mContext = null;
    private ReceiveListener mReceiveListener;
    private ConnectionListener mConnectionListener;
    private Class<?> mClassOutputLog = null;
    private Method mOutputLogCallFunctionMethod = null;
    private Method mOutputLogReturnFunctionMethod = null;
    private Method mOutputExceptionMethod = null;
    private Method mOutputLogEventMethod = null;
    private Method mReadLogSettingsMethod = null;
    private static final int NO_EXCEPTION = 0;
    private static final int RETURN_NULL_CHARACTER = 256;
    private static final int RETURN_NULL = 257;
    private static int connection;
    byte[] decodeData;
    int decodeDataSize;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int PARAM_DEFAULT = -2;
    public static final int EVENT_RECONNECTING = 0;
    public static final int EVENT_RECONNECT = 1;
    public static final int EVENT_DISCONNECT = 2;

    private native int nativeEpos2CreateHandle(long[] var1);

    private native int nativeEpos2DestroyHandle(long var1);

    private native int nativeEpos2Connect(long var1, String var3, long var4, Object var6);

    private native int nativeEpos2Disconnect(long var1);

    protected native GermanyFiscalElementStatusInfo nativeEpos2GetStatus(long var1);

    protected native int nativeEpos2Operate(long var1, String var3, long var4);

    protected native String nativeEpos2GetAdmin(long var1);

    protected native String nativeEpos2GetLocation(long var1);

    public GermanyFiscalElement(Context context) throws Epos2Exception {
        this.initializeOuputLogFunctions(context);
        this.outputLogCallFunction("GermanyFiscalElement", context);
        try {
            Class<?> classInitializer = Class.forName("com.epson.epos2.NativeInitializer");
            Method initializeMethod = classInitializer.getDeclaredMethod("initializeNativeEnv", Context.class);
            initializeMethod.setAccessible(true);
            initializeMethod.invoke(classInitializer, context);
        }
        catch (Exception e) {
            this.outputException("GermanyFiscalElement", e);
            e.printStackTrace();
        }
        this.mContext = context;
        this.initializeGfeInstance();
        this.outputLogReturnFunction("GermanyFiscalElement", 0, context);
    }

    public void connect(String target, int timeout) throws Epos2Exception {
        this.outputLogCallFunction("connect", target, timeout);
        try {
            if (null == target) {
                throw new Epos2Exception(1);
            }
            this.checkHandle();
            int errStatus = this.nativeEpos2Connect(this.mGfeHandle, target, timeout, this.mContext);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("connect", ex);
            this.outputLogReturnFunction("connect", ex.getErrorStatus(), target, timeout);
            throw ex;
        }
        this.outputLogReturnFunction("connect", 0, target, timeout);
    }

    public void disconnect() throws Epos2Exception {
        this.outputLogCallFunction("disconnect", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2Disconnect(this.mGfeHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("disconnect", ex);
            this.outputLogReturnFunction("disconnect", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("disconnect", 0, new Object[0]);
    }

    public GermanyFiscalElementStatusInfo getStatus() {
        this.outputLogCallFunction("getStatus", new Object[0]);
        GermanyFiscalElementStatusInfo status = this.nativeEpos2GetStatus(this.mGfeHandle);
        if (status != null) {
            connection = status.getConnection();
            this.outputLogReturnFunction("getStatus", 0, "connection->" + connection);
        } else {
            this.outputLogReturnFunction("getStatus", 257, new Object[0]);
        }
        return status;
    }

    public void operate(String jsonString, int timeout) throws Epos2Exception {
        this.outputLogCallFunction("operate", new Object[0]);
        try {
            this.checkHandle();
            if (null == jsonString) {
                throw new Epos2Exception(1);
            }
            int errStatus = this.nativeEpos2Operate(this.mGfeHandle, jsonString, timeout);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("operate", ex);
            this.outputLogReturnFunction("operate", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("operate", 0, new Object[0]);
    }

    public String getAdmin() {
        String admin = null;
        this.outputLogCallFunction("getAdmin", new Object[0]);
        if (this.mGfeHandle == 0L) {
            this.outputLogReturnFunction("getAdmin", 256, new Object[0]);
            return "";
        }
        admin = this.nativeEpos2GetAdmin(this.mGfeHandle);
        if (admin != null) {
            this.outputLogReturnFunction("getAdmin", 0, admin);
        } else {
            this.outputLogReturnFunction("getAdmin", 256, new Object[0]);
        }
        return admin;
    }

    public String getLocation() {
        String location = null;
        this.outputLogCallFunction("getLocation", new Object[0]);
        if (this.mGfeHandle == 0L) {
            this.outputLogReturnFunction("getLocation", 256, new Object[0]);
            return "";
        }
        location = this.nativeEpos2GetLocation(this.mGfeHandle);
        if (location != null) {
            this.outputLogReturnFunction("getLocation", 0, location);
        } else {
            this.outputLogReturnFunction("getLocation", 256, new Object[0]);
        }
        return location;
    }

    public void setReceiveEventListener(ReceiveListener listener) {
        if (this.mGfeHandle == 0L) {
            return;
        }
        this.mReceiveListener = listener != null ? listener : null;
    }

    public void setConnectionEventListener(ConnectionListener listener) {
        if (this.mGfeHandle == 0L) {
            return;
        }
        this.mConnectionListener = listener != null ? listener : null;
    }

    private void onGfeReceive(int code, String data) {
        this.outputLogCallFunction("onGfeReceive", code, this);
        if (this.mReceiveListener != null) {
            this.outputLogEvent("onGfeReceive", "code->", code);
            this.mReceiveListener.onGfeReceive(this, code, data);
        }
        this.outputLogReturnFunction("onGfeReceive", 0, code, this);
    }

    private void onConnection(int eventType) {
        this.outputLogCallFunction("onConnection", eventType, this);
        if (null != this.mConnectionListener) {
            this.outputLogEvent("onConnection", "eventType->", eventType);
            this.mConnectionListener.onConnection(this, eventType);
        }
        this.outputLogReturnFunction("onConnection", 0, eventType, this);
    }

    private void CreateDecodeData(String base64Data) {
        if (base64Data == null) {
            return;
        }
        this.decodeData = Base64.decode((String)base64Data, (int)0);
        this.decodeDataSize = this.decodeData.length;
    }

    private void DestroyDecodeData() {
        this.decodeData = null;
        this.decodeDataSize = 0;
    }

    protected void initializeGfeInstance() throws Epos2Exception {
        long[] bufHandle = new long[1];
        int errStatus = this.nativeEpos2CreateHandle(bufHandle);
        if (0 != errStatus) {
            throw new Epos2Exception(errStatus);
        }
        this.mGfeHandle = bufHandle[0];
        bufHandle[0] = 0L;
    }

    protected void finalize() throws Throwable {
        this.outputLogCallFunction("finalize", new Object[0]);
        this.mReceiveListener = null;
        this.mConnectionListener = null;
        try {
            if (this.mGfeHandle != 0L) {
                this.nativeEpos2Disconnect(this.mGfeHandle);
                this.nativeEpos2DestroyHandle(this.mGfeHandle);
                this.mGfeHandle = 0L;
            }
        }
        finally {
            super.finalize();
        }
        this.outputLogReturnFunction("finalize", 0, new Object[0]);
    }

    protected void checkHandle() throws Epos2Exception {
        if (this.mGfeHandle == 0L) {
            throw new Epos2Exception(255);
        }
    }

    private void initializeOuputLogFunctions(Context context) throws Epos2Exception {
        try {
            this.mClassOutputLog = Class.forName("com.epson.epos2.OutputLog");
            this.mOutputLogCallFunctionMethod = this.mClassOutputLog.getDeclaredMethod("outputLogCallFunction", String.class, Long.TYPE, Object[].class);
            this.mOutputLogCallFunctionMethod.setAccessible(true);
            this.mOutputLogReturnFunctionMethod = this.mClassOutputLog.getDeclaredMethod("outputLogReturnFunction", String.class, Long.TYPE, Integer.TYPE, Object[].class);
            this.mOutputLogReturnFunctionMethod.setAccessible(true);
            this.mOutputExceptionMethod = this.mClassOutputLog.getDeclaredMethod("outputException", String.class, Long.TYPE, Exception.class);
            this.mOutputExceptionMethod.setAccessible(true);
            this.mOutputLogEventMethod = this.mClassOutputLog.getDeclaredMethod("outputLogEvent", String.class, Long.TYPE, Object[].class);
            this.mOutputLogEventMethod.setAccessible(true);
            this.mReadLogSettingsMethod = this.mClassOutputLog.getDeclaredMethod("readLogSettings", Context.class);
            this.mReadLogSettingsMethod.setAccessible(true);
            this.mReadLogSettingsMethod.invoke(this.mClassOutputLog, context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void outputLogCallFunction(String methodName, Object ... param) {
        try {
            this.mOutputLogCallFunctionMethod.invoke(this.mClassOutputLog, methodName, this.mGfeHandle, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void outputLogReturnFunction(String methodName, int result, Object ... param) {
        try {
            this.mOutputLogReturnFunctionMethod.invoke(this.mClassOutputLog, methodName, this.mGfeHandle, result, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void outputException(String methodName, Exception exception) {
        try {
            this.mOutputExceptionMethod.invoke(this.mClassOutputLog, methodName, this.mGfeHandle, exception);
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    private void outputLogEvent(String methodName, Object ... param) {
        try {
            this.mOutputLogEventMethod.invoke(this.mClassOutputLog, methodName, this.mGfeHandle, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            System.loadLibrary("epos2");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        connection = 0;
    }
}

