/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epsonio.usb;

import com.epson.epsonio.usb.AoaUsb;
import com.epson.epsonio.usb.DeviceUsb;
import com.epson.epsonio.usb.Usb;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Vector;

public class NetUsb {
    private static final int M_INVALID_HANDLE_INDEX = -1;
    private static final int M_MAX_HANDLE_COUNT = 16;
    private static Vector<Usb> mAdapterList = new Vector();
    private static int mCurrentHandle = 0;
    private static Class<?> mClassOutputLog = null;
    private static Method mOutputLogInfoMethod = null;

    public static int getUsbType(int usbHandle, int[] usbType) {
        Usb adapter = NetUsb.getAdapter(usbHandle);
        if (null == adapter || null == usbType) {
            return 6;
        }
        usbType[0] = adapter.getUsbType();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int open(String deviceName, String deviceSettings, int[] usbHandle, Object context) throws IOException {
        Object target;
        Usb adapter = null;
        String deviceNameLocal = deviceName;
        int[] timeout = new int[]{30000};
        int result = 255;
        if (null == deviceName) return 1;
        if (null == context) {
            return 1;
        }
        if (null == usbHandle) return 1;
        if (0 == usbHandle.length) {
            return 1;
        }
        usbHandle[0] = -1;
        try {
            String deviceKernelVer = System.getProperty("os.version");
            if (deviceKernelVer != null) {
                NetUsb.outputLogInfo("KernelVer:" + deviceKernelVer);
            }
        }
        catch (Exception deviceKernelVer) {
            // empty catch block
        }
        if (deviceNameLocal.isEmpty()) {
            if (AoaUsb.isConnection(context)) {
                target = AoaUsb.getDeviceName(context);
                if (target == null) {
                    NetUsb.outputLogInfo("android.hardware.usb.UsbAccessory.getSerial is null");
                    return 2;
                }
                deviceNameLocal = deviceNameLocal + (String)target;
                adapter = new AoaUsb();
            } else {
                if (!DeviceUsb.isConnection(context)) {
                    NetUsb.outputLogInfo(new Object[0]);
                    return 2;
                }
                target = DeviceUsb.getDeviceName(context);
                if (target == null) {
                    return 255;
                }
                deviceNameLocal = deviceNameLocal + (String)target;
                adapter = new DeviceUsb();
            }
        } else {
            adapter = deviceNameLocal.matches(".*/.*") ? new DeviceUsb() : new AoaUsb();
        }
        if (NetUsb.checkDeviceName(deviceNameLocal)) {
            return 6;
        }
        target = mAdapterList;
        synchronized (target) {
            if (16 <= mAdapterList.size()) {
                return 6;
            }
        }
        result = adapter.requestPermission(context, deviceNameLocal, timeout);
        if (0 != result) {
            NetUsb.outputLogInfo(new Object[0]);
            return result;
        }
        int tempHandle = mCurrentHandle + 1;
        result = adapter.open(tempHandle, context);
        if (0 == result) {
            usbHandle[0] = mCurrentHandle = tempHandle;
            Vector<Usb> vector = mAdapterList;
            synchronized (vector) {
                mAdapterList.add(adapter);
                return result;
            }
        }
        NetUsb.outputLogInfo(new Object[0]);
        return result;
    }

    public static int close(int usbHandle) {
        try {
            Usb adapter = NetUsb.getAdapter(usbHandle);
            if (null == adapter) {
                return 6;
            }
            NetUsb.removeAdapter(usbHandle);
            if (0 == adapter.close()) {
                adapter = null;
            }
        }
        catch (Exception e) {
            return 255;
        }
        return 0;
    }

    public static int kill(int usbHandle) {
        try {
            Usb adapter = NetUsb.getAdapter(usbHandle);
            if (null == adapter) {
                return 6;
            }
            NetUsb.removeAdapter(usbHandle);
            adapter.close();
        }
        catch (Exception e) {
            return 255;
        }
        return 0;
    }

    public static int write(int usbHandle, byte[] data, int offset, int dataSize, int timelimit, int[] sentSize) {
        if (null == sentSize || 1 > sentSize.length) {
            return 1;
        }
        sentSize[0] = 0;
        if (0 > offset || 0 > dataSize) {
            return 1;
        }
        if (0 > timelimit) {
            return 1;
        }
        Usb adapter = NetUsb.getAdapter(usbHandle);
        if (null == adapter) {
            return 6;
        }
        if (0 == dataSize) {
            return 0;
        }
        if (0 > offset + dataSize) {
            return 255;
        }
        if (null == data || offset + dataSize > data.length) {
            return 1;
        }
        int[] timelimitWrite = new int[]{timelimit};
        int result = adapter.write(data, offset, dataSize, timelimitWrite, sentSize);
        return result;
    }

    public static int read(int usbHandle, byte[] data, int offset, int dataSize, int timelimit, int[] readSize) {
        if (null == readSize || 1 > readSize.length) {
            return 1;
        }
        readSize[0] = 0;
        if (0 > offset || 0 > dataSize) {
            return 1;
        }
        if (0 > timelimit) {
            return 1;
        }
        Usb adapter = NetUsb.getAdapter(usbHandle);
        if (null == adapter) {
            return 6;
        }
        if (0 == dataSize) {
            return 0;
        }
        if (0 > offset + dataSize) {
            return 255;
        }
        if (null == data || offset + dataSize > data.length) {
            return 1;
        }
        int result = 255;
        int[] timelimitRead = new int[]{timelimit};
        result = adapter.read(data, offset, dataSize, timelimitRead, readSize);
        return result;
    }

    public static int enableFlowControl(int usbHandle, int enalbe) {
        Usb adapter = NetUsb.getAdapter(usbHandle);
        if (null == adapter) {
            return 6;
        }
        return adapter.enableFlowControl(enalbe);
    }

    public static int getOnlineTMStatus(int usbHandle, int[] onlineStatus) {
        Usb adapter = NetUsb.getAdapter(usbHandle);
        if (null == adapter) {
            return 6;
        }
        return adapter.getOnlineTMStatus(onlineStatus);
    }

    public static int getOnlineDMStatus(int usbHandle, int[] onlineStatus) {
        Usb adapter = NetUsb.getAdapter(usbHandle);
        if (null == adapter) {
            return 6;
        }
        return adapter.getOnlineDMStatus(onlineStatus);
    }

    public static boolean isPowerOn(int usbHandle) {
        Usb adapter = NetUsb.getAdapter(usbHandle);
        if (null == adapter) {
            return false;
        }
        return adapter.isPowerOn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Usb getAdapter(int handle) {
        Usb adapter = null;
        try {
            Vector<Usb> vector = mAdapterList;
            synchronized (vector) {
                for (int i = 0; i < mAdapterList.size() && !(adapter = mAdapterList.get(i)).checkHandle(handle); ++i) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean removeAdapter(int handle) {
        boolean bReslt = false;
        try {
            Vector<Usb> vector = mAdapterList;
            synchronized (vector) {
                for (int i = 0; i < mAdapterList.size(); ++i) {
                    Usb adapter = mAdapterList.get(i);
                    if (!adapter.checkHandle(handle)) continue;
                    mAdapterList.remove(i);
                    bReslt = true;
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bReslt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean checkDeviceName(String deviceName) {
        boolean bReslt = false;
        try {
            Vector<Usb> vector = mAdapterList;
            synchronized (vector) {
                for (int i = 0; i < mAdapterList.size(); ++i) {
                    Usb adapter = mAdapterList.get(i);
                    if (!adapter.checkDevice(deviceName)) continue;
                    bReslt = true;
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bReslt;
    }

    private static void initializeOuputLogFunctions() {
        try {
            mClassOutputLog = Class.forName("com.epson.epos2.OutputLog");
            mOutputLogInfoMethod = mClassOutputLog.getDeclaredMethod("outputLogInfo", Long.TYPE, Object[].class);
            mOutputLogInfoMethod.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void outputLogInfo(Object ... param) {
        try {
            mOutputLogInfoMethod.invoke(mClassOutputLog, 0, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            NetUsb.initializeOuputLogFunctions();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

