package com.gingersoft.gsa.cloud.base.adapter;

import android.view.View;
import android.view.ViewGroup;

import androidx.viewpager.widget.PagerAdapter;

public abstract class BaseViewPageAdapter extends PagerAdapter {

    public abstract int getGallerySize();

    public abstract View getItemView(int position);

    @Override
    public int getCount() {
        return getGallerySize();
    }

    @Override
    public int getItemPosition(Object object) {
        return POSITION_NONE;
    }

    @Override
    public Object instantiateItem(ViewGroup container, int position) {
        View view = getItemView(position);
        if (view.getParent() == null) {
            container.addView(view);
        }
        return view;
    }


    @Override
    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    @Override
    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View) object);
    }

}
