package com.gingersoft.gsa.cloud.base.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.RemoteException;
import android.widget.Toast;

import com.gingersoft.gsa.cloud.base.utils.log.LogUtil;
import com.gingersoft.gsa.cloud.base.utils.view.ImageUtils;
import com.sunmi.peripheral.printer.InnerPrinterCallback;
import com.sunmi.peripheral.printer.InnerPrinterException;
import com.sunmi.peripheral.printer.InnerPrinterManager;
import com.sunmi.peripheral.printer.InnerResultCallbcak;
import com.sunmi.peripheral.printer.SunmiPrinterService;

import java.util.List;


public class AidlUtil {
    private static final String SERVICE＿PACKAGE = "woyou.aidlservice.jiuiv5";

    private static AidlUtil mAidlUtil = new AidlUtil();
    private Context context;

    private SunmiPrinterService sunmiPrinterService;

    private AidlUtil() {
    }

    public static AidlUtil getInstance() {
        return mAidlUtil;
    }

    /**
     * 连接服务
     *
     * @param context context
     */
    public void connectPrinterService(Context context) {
        this.context = context.getApplicationContext();
        try {
            InnerPrinterManager.getInstance().bindService(context, innerPrinterCallback);
        } catch (InnerPrinterException e) {
            e.printStackTrace();
        }
    }

    /**
     * 断开服务
     *
     * @param context context
     */
    public void disconnectPrinterService(Context context) {
        if (sunmiPrinterService != null) {
            try {
                InnerPrinterManager.getInstance().unBindService(context, innerPrinterCallback);
                sunmiPrinterService = null;
            } catch (InnerPrinterException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isConnect() {
        return sunmiPrinterService != null;
    }

    private InnerPrinterCallback innerPrinterCallback = new InnerPrinterCallback() {


        @Override
        protected void onConnected(SunmiPrinterService service) {
            sunmiPrinterService = service;
            //初始化打印机
            AidlUtil.getInstance().initPrinter();
        }

        @Override
        protected void onDisconnected() {

        }
    };

    /**
     * 设置打印浓度
     */
    private int[] darkness = new int[]{0x0600, 0x0500, 0x0400, 0x0300, 0x0200, 0x0100, 0,
            0xffff, 0xfeff, 0xfdff, 0xfcff, 0xfbff, 0xfaff};


    /**
     * 初始化打印机
     */
    public void initPrinter() {
        if (sunmiPrinterService == null) {
            Toast.makeText(context, LanguageUtils.get_language_system(context, "server.disconnected", "未連接上打印機!"), Toast.LENGTH_LONG).show();
            return;
        }

        try {
            sunmiPrinterService.printerInit(new com.sunmi.peripheral.printer.ICallback.Stub() {

                @Override
                public void onRunResult(boolean isSuccess) throws RemoteException {
                    LogUtil.d("printerInit", "onRunResult:  " + isSuccess);
                }

                @Override
                public void onReturnString(String result) throws RemoteException {
                    LogUtil.d("printerInit", "onReturnString:  " + result);
                }

                @Override
                public void onRaiseException(int code, String msg) throws RemoteException {
                    LogUtil.d("printerInit", "onRaiseException:  " + msg);
                }

                @Override
                public void onPrintResult(int code, String msg) throws RemoteException {
                    LogUtil.d("onPrintResult", "onPrintResult:  " + msg);
                }
            });
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    /**
     * 打印二维码
     */
    public void printQr(String data, int modulesize, int errorlevel) {
        if (sunmiPrinterService == null) {
            Toast.makeText(context, LanguageUtils.get_language_system(context, "server.disconnected", "未連接上打印機!"), Toast.LENGTH_LONG).show();
            return;
        }
        try {
            sunmiPrinterService.setAlignment(1, null);
            sunmiPrinterService.printQRCode(data, modulesize, errorlevel, null);
            sunmiPrinterService.lineWrap(1, null);
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    /**
     * 打印条形码
     */
    public void printBarCode(String data, int symbology, int height, int width, int textposition) {
        if (sunmiPrinterService == null) {
            Toast.makeText(context, LanguageUtils.get_language_system(context, "server.disconnected", "未連接上打印機!"), Toast.LENGTH_LONG).show();
            return;
        }


        try {
            sunmiPrinterService.printBarCode(data, symbology, height, width, textposition, null);
            sunmiPrinterService.lineWrap(3, null);
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    /*
     *打印图片
     */
    public void printBitmap(Bitmap bitmap, InnerResultCallbcak mInnerResultCallbcak) {
//        if (sunmiPrinterService == null) {
//            Toast.makeText(context, LanguageUtils.get_language_system(context, "server.disconnected", "未連接上打印機!"), Toast.LENGTH_LONG).show();
//            return;
//        }

        try {
            sunmiPrinterService.setAlignment(1, null);
            sunmiPrinterService.printBitmap(bitmap, mInnerResultCallbcak);
            sunmiPrinterService.lineWrap(3, null);
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    /*
     *打印图片
     */
    public void printBitmaps(List<Bitmap> bitmaps, int paperWidth, InnerResultCallbcak mInnerResultCallbcak) {
//        if (sunmiPrinterService == null) {
//            Toast.makeText(context, LanguageUtils.get_language_system(context, "server.disconnected", "未連接上打印機!"), Toast.LENGTH_LONG).show();
//            return;
//        }

        try {
            sunmiPrinterService.setAlignment(1, null);
            for (int i = 0; i < bitmaps.size(); i++) {
                sunmiPrinterService.printBitmap(ImageUtils.zoomDrawable(bitmaps.get(i), paperWidth), mInnerResultCallbcak);
                sunmiPrinterService.lineWrap(3, null);
            }
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    /**
     * 打印图片和文字按照指定排列顺序
     */
    public void printBitmap(Bitmap bitmap, int orientation) {
        if (sunmiPrinterService == null) {
            Toast.makeText(context, "服務已斷開！", Toast.LENGTH_LONG).show();
            return;
        }

        try {
            if (orientation == 0) {
                sunmiPrinterService.printBitmap(bitmap, null);
//                sunmiPrinterService.printText("横向排列\n", null);
//                sunmiPrinterService.printBitmap(bitmap, null);
//                sunmiPrinterService.printText("横向排列\n", null);
            } else {
                sunmiPrinterService.printBitmap(bitmap, null);
//                sunmiPrinterService.printText("\n纵向排列\n", null);
//                sunmiPrinterService.printBitmap(bitmap, null);
//                sunmiPrinterService.printText("\n纵向排列\n", null);
            }
            sunmiPrinterService.lineWrap(3, null);
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    /**
     * 打印表格
     */
//    public void printTable(LinkedList<TableItem> list) {
//        if (sunmiPrinterService == null) {
//            Toast.makeText(context,LanguageUtils.get_language_system(context, "server.disconnected", "未連接上打印機!"),Toast.LENGTH_LONG).show();
//            return;
//        }
//
//        try {
//            for (TableItem tableItem : list) {
//                Log.i("kaltin", "printTable: "+tableItem.getText()[0]+tableItem.getText()[1]+tableItem.getText()[2]);
//                sunmiPrinterService.printColumnsString(tableItem.getText(), tableItem.getWidth(), tableItem.getAlign(), null);
//            }
//            sunmiPrinterService.lineWrap(3, null);
//        } catch (RemoteException e) {
//            e.printStackTrace();
//        }
//    }

    /*
     * 空打三行！
     */
    public void print3Line() {
        if (sunmiPrinterService == null) {
            Toast.makeText(context, LanguageUtils.get_language_system(context, "server.disconnected", "未連接上打印機!"), Toast.LENGTH_LONG).show();
            return;
        }

        try {
            sunmiPrinterService.lineWrap(3, null);
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void sendRawData(byte[] data) {
        if (sunmiPrinterService == null) {
            Toast.makeText(context, LanguageUtils.get_language_system(context, "server.disconnected", "未連接上打印機!"), Toast.LENGTH_LONG).show();
            return;
        }

        try {
            sunmiPrinterService.sendRAWData(data, null);
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void printerSelfChecking(com.sunmi.peripheral.printer.ICallback callback) {
        if (sunmiPrinterService == null) {
            Toast.makeText(context, LanguageUtils.get_language_system(context, "server.disconnected", "未連接上打印機!"), Toast.LENGTH_LONG).show();
            return;
        }

        try {
            sunmiPrinterService.printerSelfChecking(callback);
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    /**
     * 1 ! 打印机⼯作正常
     * 2 ! 打印机准备中
     * 3 ! 通讯异常
     * 4 ! 缺纸
     * 5 ! 过热
     * 6 ! 开盖
     * 7 ! 切⼑异常
     * 8 ! 切⼑恢复
     * 9 ! 未检测到⿊标
     * 505 !未检测到打印机
     * 507 !打印机固件升级失败
     *
     * @return
     */
    public int updatePrinterState() {
        if (sunmiPrinterService == null) {
            Toast.makeText(context, LanguageUtils.get_language_system(context, "server.disconnected", "未連接上打印機!"), Toast.LENGTH_LONG).show();
            return 2;
        }

        try {
            return sunmiPrinterService.updatePrinterState();
        } catch (RemoteException e) {
            e.printStackTrace();
        }
        return 2;
    }


}
