package com.gingersoft.coldchain_module.mvp.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import android.widget.EditText;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;

import com.gingersoft.coldchain_module.R;
import com.gingersoft.coldchain_module.R2;
import com.gingersoft.coldchain_module.di.component.DaggerSupplementOrderComponent;
import com.gingersoft.coldchain_module.di.module.SupplementOrderModule;
import com.gingersoft.coldchain_module.mvp.constans.ColdChainConstants;
import com.gingersoft.coldchain_module.mvp.contract.SupplementOrderContract;
import com.gingersoft.coldchain_module.mvp.model.bean.SupplementInfoBean;
import com.gingersoft.coldchain_module.mvp.presenter.SupplementOrderPresenter;
import com.gingersoft.gsa.cloud.account.restaurant.ResturantInfoManager;
import com.gingersoft.gsa.cloud.base.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.widget.QMUITopBar;

import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;

/**
 * 補單
 */
public class SupplementOrderActivity extends BaseActivity<SupplementOrderPresenter> implements SupplementOrderContract.View {
    @BindView(R2.id.cold_chain_supplement_order_top_bar)
    QMUITopBar topBar;
    @BindView(R2.id.tv_supplement_order_name)
    TextView mTvName;
    @BindView(R2.id.tv_supplement_order_address)
    TextView mTvAddress;
    @BindView(R2.id.tv_supplement_order_phone)
    TextView mTvPhone;
    @BindView(R2.id.ed_supplement_order_number)
    EditText mEdSupplementNum;
    @BindView(R2.id.tv_supplement_tip)
    TextView mTvTip;
    private int restaurantId;

    private int supplementNum;
    private int allSupplementNum;

    private int pickUpNum;
    private String name;
    private String phone;
    private String address;

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerSupplementOrderComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .supplementOrderModule(new SupplementOrderModule(this))
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.activity_supplement_order; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        restaurantId = ResturantInfoManager.newInstance().getRestaurantId();

        mPresenter.getNumByOrderType(restaurantId);

        findViewById(R.id.btn_confirm_supplement_order).setOnClickListener(v -> {
            supplementNum = 0;
            //補單
            if (mEdSupplementNum != null && TextUtil.isNotEmptyOrNullOrUndefined(mEdSupplementNum.getText().toString())
                    && Integer.parseInt(mEdSupplementNum.getText().toString()) > 0) {
                supplementNum = Integer.parseInt(mEdSupplementNum.getText().toString());
                allSupplementNum = supplementNum;
                if (supplementNum > pickUpNum) {
                    showMessage("補單數量不能超過" + pickUpNum + "單");
                    return;
                }
                if (TextUtil.isEmptyOrNullOrUndefined(name)) {
                    showMessage("未獲取到收貨人姓名");
                    return;
                }
                if (TextUtil.isEmptyOrNullOrUndefined(phone)) {
                    showMessage("未獲取到收貨人手機號");
                    return;
                }
                if (TextUtil.isEmptyOrNullOrUndefined(address)) {
                    showMessage("未獲取到收貨地址");
                    return;
                }
                mPresenter.submitOrder(supplementNum, allSupplementNum, name, phone, address);
            } else {
                showMessage("補單數量必須大於0");
            }
        });
    }

    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {
        topBar.setTitle("補單");
        topBar.addLeftImageButton(R.drawable.icon_return, R.id.iv_left_back).setOnClickListener(v -> killMyself());
        topBar.setBackgroundColor(ContextCompat.getColor(mContext, R.color.theme_color));
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {
        if (message != null)
            LoadingDialog.showDialogForLoading(this, message, true);
        else
            LoadingDialog.showDialogForLoading(this);
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showMessage(@NonNull String message) {
        ArmsUtils.makeText(this, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }

    @Override
    public void loadNumber(SupplementInfoBean bean) {
        if (bean != null && bean.getData() != null) {
            SupplementInfoBean.DataBean dataBean = bean.getData();
            mTvAddress.setText(dataBean.getReplenishmentAddress());
            mTvTip.setText(dataBean.getPickUpPrompt());
            mTvName.setText(dataBean.getReplenishmentPerson());
            mTvPhone.setText(dataBean.getReplenishmentPhone());

            name = dataBean.getReplenishmentPerson();
            phone = dataBean.getReplenishmentPhone();
            address = dataBean.getReplenishmentAddress();

            if (dataBean.getOrderVOS() != null) {
                int orderNum = 0;
                for (SupplementInfoBean.DataBean.OrderVOSBean orderVOSBean : dataBean.getOrderVOS()) {
                    if (orderVOSBean.getOrderType() == ColdChainConstants.orderType) {
                        orderNum = orderVOSBean.getOrderNum();
                    }
                }
                pickUpNum = dataBean.getColdChainPickUpNum() - orderNum;
                if (orderNum > dataBean.getColdChainPickUpNum()) {
                    showMessage("訂單數已滿足，不需要補單");
                    killMyself();
                } else {
                    if (pickUpNum > 0) {
                        mEdSupplementNum.setText(pickUpNum + "");
                    } else {
                        showMessage("訂單數已滿足，不需要補單");
                        killMyself();
                    }
                }
            }
        }
    }

    @Override
    public void submissionComplete() {
        supplementNum--;
        if (supplementNum > 0) {
            mPresenter.submitOrder(supplementNum, allSupplementNum, name, phone, address);
        } else {
//            showMessage("補單完成");
            killMyself();
        }
    }

    @Override
    public void submissionFail() {
        showMessage("補單失敗");
        killMyself();
    }
}
