package com.gingersoft.coldchain_module.mvp.ui.adapter;

import android.content.Context;
import android.graphics.pdf.PdfDocument;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.print.PageRange;
import android.print.PrintAttributes;
import android.print.PrintDocumentAdapter;
import android.print.PrintDocumentInfo;
import android.print.pdf.PrintedPdfDocument;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * 创建打印适配器
 */
public class MyPrintDocumentAdapter extends PrintDocumentAdapter {
    private Context mContext;
    private String mFilePath;
    private PrintedPdfDocument mPdfDocument;

    public PdfDocument myPdfDocument;
    private InputStream input;

    private onPrintStatusChangeListener onPrintStatusChangeListener;

    public MyPrintDocumentAdapter(Context context, File file, onPrintStatusChangeListener onPrintStatusChangeListener) {
        this.mContext = context;
        this.mFilePath = file.getPath();
        this.onPrintStatusChangeListener = onPrintStatusChangeListener;
    }



    //当打印进程开始，该方法就将被调用，
    @Override
    public void onStart() {
        super.onStart();
    }

    //当用户改变了打印输出时，比方说页面尺寸，或者页面的方向时，
    // 该函数将被调用。以此会给我们的应用重新计划打印页面的布局，
    // 另外该方法必须返回打印文档包含多少页面。
    @Override
    public void onLayout(PrintAttributes printAttributes,
                         PrintAttributes printAttributes1,
                         CancellationSignal cancellationSignal,
                         LayoutResultCallback layoutResultCallback,
                         Bundle bundle) {
//            //使用请求的页属性创建新的pdfdocument
//            mPdfDocument=new PrintedPdfDocument(mContext,printAttributes1);
        // 响应取消请求
        if (cancellationSignal.isCanceled()) {
            layoutResultCallback.onLayoutCancelled();
            return;
        }
        // 将打印信息返回到打印框架
        PrintDocumentInfo info = new PrintDocumentInfo
                .Builder("name")
                .setContentType(PrintDocumentInfo.CONTENT_TYPE_DOCUMENT)
                .build();
        layoutResultCallback.onLayoutFinished(info, true);
    }

    //此函数被调用后，会将打印页面渲染成一个待打印的文件，该函数
    // 可以在onLayout被调用后调用一次或多次
    @Override
    public void onWrite(PageRange[] pageRanges,
                        ParcelFileDescriptor parcelFileDescriptor,
                        CancellationSignal cancellationSignal,
                        WriteResultCallback writeResultCallback) {
        InputStream input = null;
        OutputStream output = null;
        try {
            input = new FileInputStream(mFilePath);
            output = new FileOutputStream(parcelFileDescriptor.getFileDescriptor());
            byte[] buf = new byte[1024];
            int bytesRead;
            while ((bytesRead = input.read(buf)) > 0) {
                output.write(buf, 0, bytesRead);
            }

            writeResultCallback.onWriteFinished(new PageRange[]{PageRange.ALL_PAGES});
        } catch (FileNotFoundException e) {
            if (onPrintStatusChangeListener != null) {
                onPrintStatusChangeListener.onStatusChange(-1, "未找到待打印文件");
            }
//            Toast.makeText(mContext, "未找到待打印文件", Toast.LENGTH_SHORT).show();
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (output != null) {
                try {
                    output.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    input.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
//        Toast.makeText(mContext, "待打印状态", Toast.LENGTH_SHORT).show();
    }

    //一旦打印进程结束后，该函数将会被调用。如果我们的应用有任何
    // 一次性销毁任务要执行，让这些任务在该方法内执行。这个回调方法不是必须实现的。
    @Override
    public void onFinish() {
//        Toast.makeText(mContext, "已发送打印", Toast.LENGTH_SHORT).show();
        if (onPrintStatusChangeListener != null) {
            onPrintStatusChangeListener.onStatusChange(0, "打印文件已發送");
        }
        super.onFinish();
    }


    public interface onPrintStatusChangeListener {
        void onStatusChange(int code, String msg);
    }
}

