package com.gingersoft.gsa.cloud.database.greendao;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import com.gingersoft.gsa.cloud.database.bean.Food;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "FOOD".
*/
public class FoodDao extends AbstractDao<Food, Long> {

    public static final String TABLENAME = "FOOD";

    /**
     * Properties of entity Food.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "FID");
        public final static Property ParentId = new Property(1, long.class, "parentId", false, "PARENT_ID");
        public final static Property RestaurantId = new Property(2, long.class, "restaurantId", false, "RESTAURANT_ID");
        public final static Property IsParent = new Property(3, byte.class, "isParent", false, "IS_PARENT");
        public final static Property SeqNo = new Property(4, long.class, "seqNo", false, "SEQ_NO");
        public final static Property FoodName = new Property(5, String.class, "foodName", false, "FOOD_NAME");
        public final static Property FoodName1 = new Property(6, String.class, "foodName1", false, "FOOD_NAME1");
        public final static Property FoodName2 = new Property(7, String.class, "foodName2", false, "FOOD_NAME2");
        public final static Property Plu = new Property(8, String.class, "plu", false, "PLU");
        public final static Property PosFid = new Property(9, String.class, "posFid", false, "POS_FID");
        public final static Property FoodDesc = new Property(10, String.class, "foodDesc", false, "FOOD_DESC");
        public final static Property LimitAmount = new Property(11, long.class, "limitAmount", false, "LIMIT_AMOUNT");
        public final static Property LimitType = new Property(12, long.class, "limitType", false, "LIMIT_TYPE");
        public final static Property FoodSummary = new Property(13, String.class, "foodSummary", false, "FOOD_SUMMARY");
        public final static Property Invisible = new Property(14, long.class, "invisible", false, "INVISIBLE");
        public final static Property AutoMod = new Property(15, byte.class, "autoMod", false, "AUTO_MOD");
        public final static Property Price = new Property(16, double.class, "price", false, "PRICE");
        public final static Property MarketPrice = new Property(17, double.class, "marketPrice", false, "MARKET_PRICE");
        public final static Property LunchboxPrice = new Property(18, double.class, "lunchboxPrice", false, "LUNCHBOX_PRICE");
        public final static Property ImgUrlSmall = new Property(19, String.class, "imgUrlSmall", false, "IMG_URL_SMALL");
        public final static Property Imageurl = new Property(20, String.class, "imageurl", false, "IMAGEURL");
        public final static Property RiceponInvisible = new Property(21, long.class, "riceponInvisible", false, "RICEPON_INVISIBLE");
        public final static Property Cost = new Property(22, double.class, "cost", false, "COST");
        public final static Property StartDate = new Property(23, java.util.Date.class, "startDate", false, "START_DATE");
        public final static Property EndDate = new Property(24, java.util.Date.class, "endDate", false, "END_DATE");
        public final static Property Like = new Property(25, long.class, "like", false, "LIKE");
        public final static Property TotalSold = new Property(26, long.class, "totalSold", false, "TOTAL_SOLD");
        public final static Property IsSold = new Property(27, long.class, "isSold", false, "IS_SOLD");
        public final static Property CreateBy = new Property(28, String.class, "createBy", false, "CREATE_BY");
        public final static Property CreateTime = new Property(29, java.util.Date.class, "createTime", false, "CREATE_TIME");
        public final static Property UpdateBy = new Property(30, String.class, "updateBy", false, "UPDATE_BY");
        public final static Property UpdateTime = new Property(31, java.util.Date.class, "updateTime", false, "UPDATE_TIME");
        public final static Property PeriodId = new Property(32, long.class, "periodId", false, "PERIOD_ID");
        public final static Property AbleDiscount = new Property(33, long.class, "ableDiscount", false, "ABLE_DISCOUNT");
        public final static Property Takeaway = new Property(34, long.class, "takeaway", false, "TAKEAWAY");
        public final static Property BlueEdit = new Property(35, long.class, "blueEdit", false, "BLUE_EDIT");
        public final static Property CartEdit = new Property(36, long.class, "cartEdit", false, "CART_EDIT");
        public final static Property AutoMerge = new Property(37, long.class, "autoMerge", false, "AUTO_MERGE");
        public final static Property PrintSeting = new Property(38, String.class, "printSeting", false, "PRINT_SETING");
        public final static Property IsPrintQueueCode = new Property(39, long.class, "isPrintQueueCode", false, "IS_PRINT_QUEUE_CODE");
        public final static Property QueueHeadId = new Property(40, long.class, "queueHeadId", false, "QUEUE_HEAD_ID");
        public final static Property Approve = new Property(41, long.class, "approve", false, "APPROVE");
        public final static Property PrintFont = new Property(42, long.class, "printFont", false, "PRINT_FONT");
        public final static Property AdvPrice = new Property(43, long.class, "advPrice", false, "ADV_PRICE");
        public final static Property PrintToBill = new Property(44, long.class, "printToBill", false, "PRINT_TO_BILL");
        public final static Property PointsAdd = new Property(45, double.class, "pointsAdd", false, "POINTS_ADD");
        public final static Property PointsRatio = new Property(46, long.class, "pointsRatio", false, "POINTS_RATIO");
        public final static Property PointsRedeem = new Property(47, double.class, "pointsRedeem", false, "POINTS_REDEEM");
        public final static Property KtPrintMainItem = new Property(48, long.class, "ktPrintMainItem", false, "KT_PRINT_MAIN_ITEM");
        public final static Property KtShowPrice = new Property(49, long.class, "ktShowPrice", false, "KT_SHOW_PRICE");
        public final static Property PrintTo = new Property(50, long.class, "printTo", false, "PRINT_TO");
        public final static Property ToPax = new Property(51, long.class, "toPax", false, "TO_PAX");
        public final static Property FoodType = new Property(52, long.class, "foodType", false, "FOOD_TYPE");
        public final static Property MajorMainId = new Property(53, long.class, "majorMainId", false, "MAJOR_MAIN_ID");
        public final static Property DeptId = new Property(54, long.class, "deptId", false, "DEPT_ID");
        public final static Property ServiceCharge = new Property(55, byte.class, "serviceCharge", false, "SERVICE_CHARGE");
        public final static Property ColorId = new Property(56, long.class, "colorId", false, "COLOR_ID");
        public final static Property Conditions = new Property(57, long.class, "conditions", false, "CONDITIONS");
        public final static Property IsRt = new Property(58, long.class, "isRt", false, "IS_RT");
        public final static Property Deletes = new Property(59, long.class, "deletes", false, "DELETES");
        public final static Property IsTimingFood = new Property(60, long.class, "isTimingFood", false, "IS_TIMING_FOOD");
        public final static Property MinLongTime = new Property(61, long.class, "minLongTime", false, "MIN_LONG_TIME");
        public final static Property UnitTime = new Property(62, long.class, "unitTime", false, "UNIT_TIME");
        public final static Property UnitPrice = new Property(63, double.class, "unitPrice", false, "UNIT_PRICE");
        public final static Property FreeLongTime = new Property(64, long.class, "freeLongTime", false, "FREE_LONG_TIME");
        public final static Property FreePeriodBegin = new Property(65, java.util.Date.class, "freePeriodBegin", false, "FREE_PERIOD_BEGIN");
        public final static Property IsStatistic = new Property(66, long.class, "isStatistic", false, "IS_STATISTIC");
    }


    public FoodDao(DaoConfig config) {
        super(config);
    }
    
    public FoodDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"FOOD\" (" + //
                "\"FID\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: id
                "\"PARENT_ID\" INTEGER NOT NULL ," + // 1: parentId
                "\"RESTAURANT_ID\" INTEGER NOT NULL ," + // 2: restaurantId
                "\"IS_PARENT\" INTEGER NOT NULL ," + // 3: isParent
                "\"SEQ_NO\" INTEGER NOT NULL ," + // 4: seqNo
                "\"FOOD_NAME\" TEXT," + // 5: foodName
                "\"FOOD_NAME1\" TEXT," + // 6: foodName1
                "\"FOOD_NAME2\" TEXT," + // 7: foodName2
                "\"PLU\" TEXT," + // 8: plu
                "\"POS_FID\" TEXT," + // 9: posFid
                "\"FOOD_DESC\" TEXT," + // 10: foodDesc
                "\"LIMIT_AMOUNT\" INTEGER NOT NULL ," + // 11: limitAmount
                "\"LIMIT_TYPE\" INTEGER NOT NULL ," + // 12: limitType
                "\"FOOD_SUMMARY\" TEXT," + // 13: foodSummary
                "\"INVISIBLE\" INTEGER NOT NULL ," + // 14: invisible
                "\"AUTO_MOD\" INTEGER NOT NULL ," + // 15: autoMod
                "\"PRICE\" REAL NOT NULL ," + // 16: price
                "\"MARKET_PRICE\" REAL NOT NULL ," + // 17: marketPrice
                "\"LUNCHBOX_PRICE\" REAL NOT NULL ," + // 18: lunchboxPrice
                "\"IMG_URL_SMALL\" TEXT," + // 19: imgUrlSmall
                "\"IMAGEURL\" TEXT," + // 20: imageurl
                "\"RICEPON_INVISIBLE\" INTEGER NOT NULL ," + // 21: riceponInvisible
                "\"COST\" REAL NOT NULL ," + // 22: cost
                "\"START_DATE\" INTEGER," + // 23: startDate
                "\"END_DATE\" INTEGER," + // 24: endDate
                "\"LIKE\" INTEGER NOT NULL ," + // 25: like
                "\"TOTAL_SOLD\" INTEGER NOT NULL ," + // 26: totalSold
                "\"IS_SOLD\" INTEGER NOT NULL ," + // 27: isSold
                "\"CREATE_BY\" TEXT," + // 28: createBy
                "\"CREATE_TIME\" INTEGER," + // 29: createTime
                "\"UPDATE_BY\" TEXT," + // 30: updateBy
                "\"UPDATE_TIME\" INTEGER," + // 31: updateTime
                "\"PERIOD_ID\" INTEGER NOT NULL ," + // 32: periodId
                "\"ABLE_DISCOUNT\" INTEGER NOT NULL ," + // 33: ableDiscount
                "\"TAKEAWAY\" INTEGER NOT NULL ," + // 34: takeaway
                "\"BLUE_EDIT\" INTEGER NOT NULL ," + // 35: blueEdit
                "\"CART_EDIT\" INTEGER NOT NULL ," + // 36: cartEdit
                "\"AUTO_MERGE\" INTEGER NOT NULL ," + // 37: autoMerge
                "\"PRINT_SETING\" TEXT," + // 38: printSeting
                "\"IS_PRINT_QUEUE_CODE\" INTEGER NOT NULL ," + // 39: isPrintQueueCode
                "\"QUEUE_HEAD_ID\" INTEGER NOT NULL ," + // 40: queueHeadId
                "\"APPROVE\" INTEGER NOT NULL ," + // 41: approve
                "\"PRINT_FONT\" INTEGER NOT NULL ," + // 42: printFont
                "\"ADV_PRICE\" INTEGER NOT NULL ," + // 43: advPrice
                "\"PRINT_TO_BILL\" INTEGER NOT NULL ," + // 44: printToBill
                "\"POINTS_ADD\" REAL NOT NULL ," + // 45: pointsAdd
                "\"POINTS_RATIO\" INTEGER NOT NULL ," + // 46: pointsRatio
                "\"POINTS_REDEEM\" REAL NOT NULL ," + // 47: pointsRedeem
                "\"KT_PRINT_MAIN_ITEM\" INTEGER NOT NULL ," + // 48: ktPrintMainItem
                "\"KT_SHOW_PRICE\" INTEGER NOT NULL ," + // 49: ktShowPrice
                "\"PRINT_TO\" INTEGER NOT NULL ," + // 50: printTo
                "\"TO_PAX\" INTEGER NOT NULL ," + // 51: toPax
                "\"FOOD_TYPE\" INTEGER NOT NULL ," + // 52: foodType
                "\"MAJOR_MAIN_ID\" INTEGER NOT NULL ," + // 53: majorMainId
                "\"DEPT_ID\" INTEGER NOT NULL ," + // 54: deptId
                "\"SERVICE_CHARGE\" INTEGER NOT NULL ," + // 55: serviceCharge
                "\"COLOR_ID\" INTEGER NOT NULL ," + // 56: colorId
                "\"CONDITIONS\" INTEGER NOT NULL ," + // 57: conditions
                "\"IS_RT\" INTEGER NOT NULL ," + // 58: isRt
                "\"DELETES\" INTEGER NOT NULL ," + // 59: deletes
                "\"IS_TIMING_FOOD\" INTEGER NOT NULL ," + // 60: isTimingFood
                "\"MIN_LONG_TIME\" INTEGER NOT NULL ," + // 61: minLongTime
                "\"UNIT_TIME\" INTEGER NOT NULL ," + // 62: unitTime
                "\"UNIT_PRICE\" REAL NOT NULL ," + // 63: unitPrice
                "\"FREE_LONG_TIME\" INTEGER NOT NULL ," + // 64: freeLongTime
                "\"FREE_PERIOD_BEGIN\" INTEGER," + // 65: freePeriodBegin
                "\"IS_STATISTIC\" INTEGER NOT NULL );"); // 66: isStatistic
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"FOOD\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, Food entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
        stmt.bindLong(2, entity.getParentId());
        stmt.bindLong(3, entity.getRestaurantId());
        stmt.bindLong(4, entity.getIsParent());
        stmt.bindLong(5, entity.getSeqNo());
 
        String foodName = entity.getFoodName();
        if (foodName != null) {
            stmt.bindString(6, foodName);
        }
 
        String foodName1 = entity.getFoodName1();
        if (foodName1 != null) {
            stmt.bindString(7, foodName1);
        }
 
        String foodName2 = entity.getFoodName2();
        if (foodName2 != null) {
            stmt.bindString(8, foodName2);
        }
 
        String plu = entity.getPlu();
        if (plu != null) {
            stmt.bindString(9, plu);
        }
 
        String posFid = entity.getPosFid();
        if (posFid != null) {
            stmt.bindString(10, posFid);
        }
 
        String foodDesc = entity.getFoodDesc();
        if (foodDesc != null) {
            stmt.bindString(11, foodDesc);
        }
        stmt.bindLong(12, entity.getLimitAmount());
        stmt.bindLong(13, entity.getLimitType());
 
        String foodSummary = entity.getFoodSummary();
        if (foodSummary != null) {
            stmt.bindString(14, foodSummary);
        }
        stmt.bindLong(15, entity.getInvisible());
        stmt.bindLong(16, entity.getAutoMod());
        stmt.bindDouble(17, entity.getPrice());
        stmt.bindDouble(18, entity.getMarketPrice());
        stmt.bindDouble(19, entity.getLunchboxPrice());
 
        String imgUrlSmall = entity.getImgUrlSmall();
        if (imgUrlSmall != null) {
            stmt.bindString(20, imgUrlSmall);
        }
 
        String imageurl = entity.getImageurl();
        if (imageurl != null) {
            stmt.bindString(21, imageurl);
        }
        stmt.bindLong(22, entity.getRiceponInvisible());
        stmt.bindDouble(23, entity.getCost());
 
        java.util.Date startDate = entity.getStartDate();
        if (startDate != null) {
            stmt.bindLong(24, startDate.getTime());
        }
 
        java.util.Date endDate = entity.getEndDate();
        if (endDate != null) {
            stmt.bindLong(25, endDate.getTime());
        }
        stmt.bindLong(26, entity.getLike());
        stmt.bindLong(27, entity.getTotalSold());
        stmt.bindLong(28, entity.getIsSold());
 
        String createBy = entity.getCreateBy();
        if (createBy != null) {
            stmt.bindString(29, createBy);
        }
 
        java.util.Date createTime = entity.getCreateTime();
        if (createTime != null) {
            stmt.bindLong(30, createTime.getTime());
        }
 
        String updateBy = entity.getUpdateBy();
        if (updateBy != null) {
            stmt.bindString(31, updateBy);
        }
 
        java.util.Date updateTime = entity.getUpdateTime();
        if (updateTime != null) {
            stmt.bindLong(32, updateTime.getTime());
        }
        stmt.bindLong(33, entity.getPeriodId());
        stmt.bindLong(34, entity.getAbleDiscount());
        stmt.bindLong(35, entity.getTakeaway());
        stmt.bindLong(36, entity.getBlueEdit());
        stmt.bindLong(37, entity.getCartEdit());
        stmt.bindLong(38, entity.getAutoMerge());
 
        String printSeting = entity.getPrintSeting();
        if (printSeting != null) {
            stmt.bindString(39, printSeting);
        }
        stmt.bindLong(40, entity.getIsPrintQueueCode());
        stmt.bindLong(41, entity.getQueueHeadId());
        stmt.bindLong(42, entity.getApprove());
        stmt.bindLong(43, entity.getPrintFont());
        stmt.bindLong(44, entity.getAdvPrice());
        stmt.bindLong(45, entity.getPrintToBill());
        stmt.bindDouble(46, entity.getPointsAdd());
        stmt.bindLong(47, entity.getPointsRatio());
        stmt.bindDouble(48, entity.getPointsRedeem());
        stmt.bindLong(49, entity.getKtPrintMainItem());
        stmt.bindLong(50, entity.getKtShowPrice());
        stmt.bindLong(51, entity.getPrintTo());
        stmt.bindLong(52, entity.getToPax());
        stmt.bindLong(53, entity.getFoodType());
        stmt.bindLong(54, entity.getMajorMainId());
        stmt.bindLong(55, entity.getDeptId());
        stmt.bindLong(56, entity.getServiceCharge());
        stmt.bindLong(57, entity.getColorId());
        stmt.bindLong(58, entity.getConditions());
        stmt.bindLong(59, entity.getIsRt());
        stmt.bindLong(60, entity.getDeletes());
        stmt.bindLong(61, entity.getIsTimingFood());
        stmt.bindLong(62, entity.getMinLongTime());
        stmt.bindLong(63, entity.getUnitTime());
        stmt.bindDouble(64, entity.getUnitPrice());
        stmt.bindLong(65, entity.getFreeLongTime());
 
        java.util.Date freePeriodBegin = entity.getFreePeriodBegin();
        if (freePeriodBegin != null) {
            stmt.bindLong(66, freePeriodBegin.getTime());
        }
        stmt.bindLong(67, entity.getIsStatistic());
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, Food entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
        stmt.bindLong(2, entity.getParentId());
        stmt.bindLong(3, entity.getRestaurantId());
        stmt.bindLong(4, entity.getIsParent());
        stmt.bindLong(5, entity.getSeqNo());
 
        String foodName = entity.getFoodName();
        if (foodName != null) {
            stmt.bindString(6, foodName);
        }
 
        String foodName1 = entity.getFoodName1();
        if (foodName1 != null) {
            stmt.bindString(7, foodName1);
        }
 
        String foodName2 = entity.getFoodName2();
        if (foodName2 != null) {
            stmt.bindString(8, foodName2);
        }
 
        String plu = entity.getPlu();
        if (plu != null) {
            stmt.bindString(9, plu);
        }
 
        String posFid = entity.getPosFid();
        if (posFid != null) {
            stmt.bindString(10, posFid);
        }
 
        String foodDesc = entity.getFoodDesc();
        if (foodDesc != null) {
            stmt.bindString(11, foodDesc);
        }
        stmt.bindLong(12, entity.getLimitAmount());
        stmt.bindLong(13, entity.getLimitType());
 
        String foodSummary = entity.getFoodSummary();
        if (foodSummary != null) {
            stmt.bindString(14, foodSummary);
        }
        stmt.bindLong(15, entity.getInvisible());
        stmt.bindLong(16, entity.getAutoMod());
        stmt.bindDouble(17, entity.getPrice());
        stmt.bindDouble(18, entity.getMarketPrice());
        stmt.bindDouble(19, entity.getLunchboxPrice());
 
        String imgUrlSmall = entity.getImgUrlSmall();
        if (imgUrlSmall != null) {
            stmt.bindString(20, imgUrlSmall);
        }
 
        String imageurl = entity.getImageurl();
        if (imageurl != null) {
            stmt.bindString(21, imageurl);
        }
        stmt.bindLong(22, entity.getRiceponInvisible());
        stmt.bindDouble(23, entity.getCost());
 
        java.util.Date startDate = entity.getStartDate();
        if (startDate != null) {
            stmt.bindLong(24, startDate.getTime());
        }
 
        java.util.Date endDate = entity.getEndDate();
        if (endDate != null) {
            stmt.bindLong(25, endDate.getTime());
        }
        stmt.bindLong(26, entity.getLike());
        stmt.bindLong(27, entity.getTotalSold());
        stmt.bindLong(28, entity.getIsSold());
 
        String createBy = entity.getCreateBy();
        if (createBy != null) {
            stmt.bindString(29, createBy);
        }
 
        java.util.Date createTime = entity.getCreateTime();
        if (createTime != null) {
            stmt.bindLong(30, createTime.getTime());
        }
 
        String updateBy = entity.getUpdateBy();
        if (updateBy != null) {
            stmt.bindString(31, updateBy);
        }
 
        java.util.Date updateTime = entity.getUpdateTime();
        if (updateTime != null) {
            stmt.bindLong(32, updateTime.getTime());
        }
        stmt.bindLong(33, entity.getPeriodId());
        stmt.bindLong(34, entity.getAbleDiscount());
        stmt.bindLong(35, entity.getTakeaway());
        stmt.bindLong(36, entity.getBlueEdit());
        stmt.bindLong(37, entity.getCartEdit());
        stmt.bindLong(38, entity.getAutoMerge());
 
        String printSeting = entity.getPrintSeting();
        if (printSeting != null) {
            stmt.bindString(39, printSeting);
        }
        stmt.bindLong(40, entity.getIsPrintQueueCode());
        stmt.bindLong(41, entity.getQueueHeadId());
        stmt.bindLong(42, entity.getApprove());
        stmt.bindLong(43, entity.getPrintFont());
        stmt.bindLong(44, entity.getAdvPrice());
        stmt.bindLong(45, entity.getPrintToBill());
        stmt.bindDouble(46, entity.getPointsAdd());
        stmt.bindLong(47, entity.getPointsRatio());
        stmt.bindDouble(48, entity.getPointsRedeem());
        stmt.bindLong(49, entity.getKtPrintMainItem());
        stmt.bindLong(50, entity.getKtShowPrice());
        stmt.bindLong(51, entity.getPrintTo());
        stmt.bindLong(52, entity.getToPax());
        stmt.bindLong(53, entity.getFoodType());
        stmt.bindLong(54, entity.getMajorMainId());
        stmt.bindLong(55, entity.getDeptId());
        stmt.bindLong(56, entity.getServiceCharge());
        stmt.bindLong(57, entity.getColorId());
        stmt.bindLong(58, entity.getConditions());
        stmt.bindLong(59, entity.getIsRt());
        stmt.bindLong(60, entity.getDeletes());
        stmt.bindLong(61, entity.getIsTimingFood());
        stmt.bindLong(62, entity.getMinLongTime());
        stmt.bindLong(63, entity.getUnitTime());
        stmt.bindDouble(64, entity.getUnitPrice());
        stmt.bindLong(65, entity.getFreeLongTime());
 
        java.util.Date freePeriodBegin = entity.getFreePeriodBegin();
        if (freePeriodBegin != null) {
            stmt.bindLong(66, freePeriodBegin.getTime());
        }
        stmt.bindLong(67, entity.getIsStatistic());
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public Food readEntity(Cursor cursor, int offset) {
        Food entity = new Food( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.getLong(offset + 1), // parentId
            cursor.getLong(offset + 2), // restaurantId
            (byte) cursor.getShort(offset + 3), // isParent
            cursor.getLong(offset + 4), // seqNo
            cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5), // foodName
            cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6), // foodName1
            cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7), // foodName2
            cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8), // plu
            cursor.isNull(offset + 9) ? null : cursor.getString(offset + 9), // posFid
            cursor.isNull(offset + 10) ? null : cursor.getString(offset + 10), // foodDesc
            cursor.getLong(offset + 11), // limitAmount
            cursor.getLong(offset + 12), // limitType
            cursor.isNull(offset + 13) ? null : cursor.getString(offset + 13), // foodSummary
            cursor.getLong(offset + 14), // invisible
            (byte) cursor.getShort(offset + 15), // autoMod
            cursor.getDouble(offset + 16), // price
            cursor.getDouble(offset + 17), // marketPrice
            cursor.getDouble(offset + 18), // lunchboxPrice
            cursor.isNull(offset + 19) ? null : cursor.getString(offset + 19), // imgUrlSmall
            cursor.isNull(offset + 20) ? null : cursor.getString(offset + 20), // imageurl
            cursor.getLong(offset + 21), // riceponInvisible
            cursor.getDouble(offset + 22), // cost
            cursor.isNull(offset + 23) ? null : new java.util.Date(cursor.getLong(offset + 23)), // startDate
            cursor.isNull(offset + 24) ? null : new java.util.Date(cursor.getLong(offset + 24)), // endDate
            cursor.getLong(offset + 25), // like
            cursor.getLong(offset + 26), // totalSold
            cursor.getLong(offset + 27), // isSold
            cursor.isNull(offset + 28) ? null : cursor.getString(offset + 28), // createBy
            cursor.isNull(offset + 29) ? null : new java.util.Date(cursor.getLong(offset + 29)), // createTime
            cursor.isNull(offset + 30) ? null : cursor.getString(offset + 30), // updateBy
            cursor.isNull(offset + 31) ? null : new java.util.Date(cursor.getLong(offset + 31)), // updateTime
            cursor.getLong(offset + 32), // periodId
            cursor.getLong(offset + 33), // ableDiscount
            cursor.getLong(offset + 34), // takeaway
            cursor.getLong(offset + 35), // blueEdit
            cursor.getLong(offset + 36), // cartEdit
            cursor.getLong(offset + 37), // autoMerge
            cursor.isNull(offset + 38) ? null : cursor.getString(offset + 38), // printSeting
            cursor.getLong(offset + 39), // isPrintQueueCode
            cursor.getLong(offset + 40), // queueHeadId
            cursor.getLong(offset + 41), // approve
            cursor.getLong(offset + 42), // printFont
            cursor.getLong(offset + 43), // advPrice
            cursor.getLong(offset + 44), // printToBill
            cursor.getDouble(offset + 45), // pointsAdd
            cursor.getLong(offset + 46), // pointsRatio
            cursor.getDouble(offset + 47), // pointsRedeem
            cursor.getLong(offset + 48), // ktPrintMainItem
            cursor.getLong(offset + 49), // ktShowPrice
            cursor.getLong(offset + 50), // printTo
            cursor.getLong(offset + 51), // toPax
            cursor.getLong(offset + 52), // foodType
            cursor.getLong(offset + 53), // majorMainId
            cursor.getLong(offset + 54), // deptId
            (byte) cursor.getShort(offset + 55), // serviceCharge
            cursor.getLong(offset + 56), // colorId
            cursor.getLong(offset + 57), // conditions
            cursor.getLong(offset + 58), // isRt
            cursor.getLong(offset + 59), // deletes
            cursor.getLong(offset + 60), // isTimingFood
            cursor.getLong(offset + 61), // minLongTime
            cursor.getLong(offset + 62), // unitTime
            cursor.getDouble(offset + 63), // unitPrice
            cursor.getLong(offset + 64), // freeLongTime
            cursor.isNull(offset + 65) ? null : new java.util.Date(cursor.getLong(offset + 65)), // freePeriodBegin
            cursor.getLong(offset + 66) // isStatistic
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, Food entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setParentId(cursor.getLong(offset + 1));
        entity.setRestaurantId(cursor.getLong(offset + 2));
        entity.setIsParent((byte) cursor.getShort(offset + 3));
        entity.setSeqNo(cursor.getLong(offset + 4));
        entity.setFoodName(cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5));
        entity.setFoodName1(cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6));
        entity.setFoodName2(cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7));
        entity.setPlu(cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8));
        entity.setPosFid(cursor.isNull(offset + 9) ? null : cursor.getString(offset + 9));
        entity.setFoodDesc(cursor.isNull(offset + 10) ? null : cursor.getString(offset + 10));
        entity.setLimitAmount(cursor.getLong(offset + 11));
        entity.setLimitType(cursor.getLong(offset + 12));
        entity.setFoodSummary(cursor.isNull(offset + 13) ? null : cursor.getString(offset + 13));
        entity.setInvisible(cursor.getLong(offset + 14));
        entity.setAutoMod((byte) cursor.getShort(offset + 15));
        entity.setPrice(cursor.getDouble(offset + 16));
        entity.setMarketPrice(cursor.getDouble(offset + 17));
        entity.setLunchboxPrice(cursor.getDouble(offset + 18));
        entity.setImgUrlSmall(cursor.isNull(offset + 19) ? null : cursor.getString(offset + 19));
        entity.setImageurl(cursor.isNull(offset + 20) ? null : cursor.getString(offset + 20));
        entity.setRiceponInvisible(cursor.getLong(offset + 21));
        entity.setCost(cursor.getDouble(offset + 22));
        entity.setStartDate(cursor.isNull(offset + 23) ? null : new java.util.Date(cursor.getLong(offset + 23)));
        entity.setEndDate(cursor.isNull(offset + 24) ? null : new java.util.Date(cursor.getLong(offset + 24)));
        entity.setLike(cursor.getLong(offset + 25));
        entity.setTotalSold(cursor.getLong(offset + 26));
        entity.setIsSold(cursor.getLong(offset + 27));
        entity.setCreateBy(cursor.isNull(offset + 28) ? null : cursor.getString(offset + 28));
        entity.setCreateTime(cursor.isNull(offset + 29) ? null : new java.util.Date(cursor.getLong(offset + 29)));
        entity.setUpdateBy(cursor.isNull(offset + 30) ? null : cursor.getString(offset + 30));
        entity.setUpdateTime(cursor.isNull(offset + 31) ? null : new java.util.Date(cursor.getLong(offset + 31)));
        entity.setPeriodId(cursor.getLong(offset + 32));
        entity.setAbleDiscount(cursor.getLong(offset + 33));
        entity.setTakeaway(cursor.getLong(offset + 34));
        entity.setBlueEdit(cursor.getLong(offset + 35));
        entity.setCartEdit(cursor.getLong(offset + 36));
        entity.setAutoMerge(cursor.getLong(offset + 37));
        entity.setPrintSeting(cursor.isNull(offset + 38) ? null : cursor.getString(offset + 38));
        entity.setIsPrintQueueCode(cursor.getLong(offset + 39));
        entity.setQueueHeadId(cursor.getLong(offset + 40));
        entity.setApprove(cursor.getLong(offset + 41));
        entity.setPrintFont(cursor.getLong(offset + 42));
        entity.setAdvPrice(cursor.getLong(offset + 43));
        entity.setPrintToBill(cursor.getLong(offset + 44));
        entity.setPointsAdd(cursor.getDouble(offset + 45));
        entity.setPointsRatio(cursor.getLong(offset + 46));
        entity.setPointsRedeem(cursor.getDouble(offset + 47));
        entity.setKtPrintMainItem(cursor.getLong(offset + 48));
        entity.setKtShowPrice(cursor.getLong(offset + 49));
        entity.setPrintTo(cursor.getLong(offset + 50));
        entity.setToPax(cursor.getLong(offset + 51));
        entity.setFoodType(cursor.getLong(offset + 52));
        entity.setMajorMainId(cursor.getLong(offset + 53));
        entity.setDeptId(cursor.getLong(offset + 54));
        entity.setServiceCharge((byte) cursor.getShort(offset + 55));
        entity.setColorId(cursor.getLong(offset + 56));
        entity.setConditions(cursor.getLong(offset + 57));
        entity.setIsRt(cursor.getLong(offset + 58));
        entity.setDeletes(cursor.getLong(offset + 59));
        entity.setIsTimingFood(cursor.getLong(offset + 60));
        entity.setMinLongTime(cursor.getLong(offset + 61));
        entity.setUnitTime(cursor.getLong(offset + 62));
        entity.setUnitPrice(cursor.getDouble(offset + 63));
        entity.setFreeLongTime(cursor.getLong(offset + 64));
        entity.setFreePeriodBegin(cursor.isNull(offset + 65) ? null : new java.util.Date(cursor.getLong(offset + 65)));
        entity.setIsStatistic(cursor.getLong(offset + 66));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(Food entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(Food entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(Food entity) {
        return entity.getId() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
}
