package com.gingersoft.gsa.cloud.main;

import com.gingersoft.gsa.cloud.function.FModule;
import com.gingersoft.gsa.cloud.function.XFunctionItem;
import com.gingersoft.gsa.cloud.function.XFunctionItems;

/**
 * @author : bin
 * @create date: 2020-11-26
 * @update date: 2020-11-26
 * @description:
 */
public class FunctionMain {

    public static final String ORDER_GROUP = "main/order/";
    public static final String MANAGER_GROUP = "main/manager/";
    public static final String EMPLOYEE_GROUP = "main/employee/";
    /**
     * 首頁- 點餐
     */
    @XFunctionItems(ORDER_GROUP)
    public static final FModule[] order_groups = {
            new FModule(ORDER_GROUP, 0, 0),
            new FModule(ORDER_GROUP + "table", R.drawable.ic_dining_table_mode, R.drawable.ic_dining_table_mode_close),
            new FModule(ORDER_GROUP + "delivery", R.drawable.ic_delivery_mode, R.drawable.ic_delivery_mode_close),
            new FModule(ORDER_GROUP + "takeaway", R.drawable.ic_outsourcing_model, R.drawable.ic_outsourcing_model_close),
            new FModule(ORDER_GROUP + "preorder", R.drawable.ic_pre_order_mode, R.drawable.ic_pre_order_mode_close),
            new FModule(ORDER_GROUP + "coldChain", R.drawable.ic_cold_chain, R.drawable.ic_pre_order_mode_close),
    };
    /**
     * 首頁- 管理
     */
    @XFunctionItems(MANAGER_GROUP)
    public static final FModule[] manager_groups = {
            new FModule(MANAGER_GROUP, 0, 0),
            new FModule(MANAGER_GROUP + "takeaway", R.drawable.ic_meals_menu_management, R.drawable.ic_meals_menu_management_close),
            new FModule(MANAGER_GROUP + "bill", R.drawable.ic_meals_menu_management, R.drawable.ic_meals_menu_management_close),
            new FModule(MANAGER_GROUP + "table", R.drawable.ic_dining_table_management, R.drawable.ic_dining_table_management_close),
            new FModule(MANAGER_GROUP + "printer", R.drawable.ic_print_management, R.drawable.ic_print_management_close),
            new FModule(MANAGER_GROUP + "pay", R.drawable.ic_pay_management, R.drawable.ic_pay_management_close),
            new FModule(MANAGER_GROUP + "discout", R.drawable.ic_discount_management, R.drawable.ic_discount_management_close),
            new FModule(MANAGER_GROUP + "soldoutCtr", R.drawable.ic_sell_off_manger, R.drawable.ic_sell_off_manger),
            new FModule(MANAGER_GROUP + "qrCode", R.drawable.ic_discount_management, R.drawable.ic_discount_management_close)
    };

    /**
     * 首頁- 員工管理
     */
    @XFunctionItems(EMPLOYEE_GROUP)
    public static final FModule[] employee_groups = {
            new FModule(EMPLOYEE_GROUP, 0, 0),
            new FModule(EMPLOYEE_GROUP + "management", R.drawable.ic_staff_management, R.drawable.ic_staff_management_close),
            new FModule(EMPLOYEE_GROUP + "delivery", R.drawable.ic_authority_management, R.drawable.ic_authority_management_close),
            new FModule(EMPLOYEE_GROUP + "operationRecord", R.drawable.ic_operation_record, R.drawable.ic_operation_record_close)
    };


}
