package com.gingersoft.gsa.cloud.main.di.module;

import com.jess.arms.di.scope.ActivityScope;

import dagger.Module;
import dagger.Provides;

import com.gingersoft.gsa.cloud.main.mvp.contract.ExpandListContract;
import com.gingersoft.gsa.cloud.main.mvp.model.ExpandListModel;


@Module
public class ExpandListModule {
    private ExpandListContract.View view;

    /**
     * 构建ExpandListModule时,将View的实现类传进来,这样就可以提供View的实现类给presenter
     *
     * @param view
     */
    public ExpandListModule(ExpandListContract.View view) {
        this.view = view;
    }

    @ActivityScope
    @Provides
    ExpandListContract.View provideExpandListView() {
        return this.view;
    }

    @ActivityScope
    @Provides
    ExpandListContract.Model provideExpandListModel(ExpandListModel model) {
        return model;
    }
}