package com.gingersoft.gsa.cloud.main.mvp.model.service;

import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;

import io.reactivex.Observable;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/18
 * Time: 10:35
 * Use:
 */
public interface FoodMenuService {

    @Headers({"Domain-Name: ricepon_restaurant"})
    @GET("period/getPeriodList" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getPeriodList(@Query("brandId") int brandId);

    @Headers({"Domain-Name: ricepon_restaurant"})
    @POST("period/addPeriod" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> addPeriod(@Body RequestBody requestBody);

    @Headers({"Domain-Name: ricepon_restaurant"})
    @POST("period/updatePeriod" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> updatePeriod(@Body RequestBody requestBody);

    @Headers({"Domain-Name: ricepon_restaurant"})
    @FormUrlEncoded
    @POST("period/deletePeriod" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> deletePeriod(@Field("id") int id);

    @Headers({"Domain-Name: ricepon_restaurant"})
    @GET("summary/getSummaryList" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getSummaryList(@Query("restaurantId") int restaurantId);

    @Headers({"Domain-Name: ricepon_restaurant"})
    @POST("summary/addSummary" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> addSummary(@Body RequestBody requestBody);

    @Headers({"Domain-Name: ricepon_restaurant"})
    @POST("summary/updateSummary" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> updateSummary(@Body RequestBody requestBody);

    @Headers({"Domain-Name: ricepon_restaurant"})
    @FormUrlEncoded
    @POST("summary/deleteSummary" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> deleteSummary(@Field("id") int id);

}
