package com.gingersoft.gsa.cloud.main.mvp.model.service;

import com.gingersoft.gsa.cloud.main.mvp.model.bean.BusinessDetailsBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.DaySalesReportBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.DeliveryLineChartBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.DeliveryPersonnelReportBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.DiscountDetailsReportBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.MainBusinessBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.MainOrderInfoChartBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.OrderAnalysisBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.OrderDetailsReport;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.PaymentMethodBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.SalesFoodsBean;

import java.util.Map;

import io.reactivex.Observable;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;

/**
 * Created by Wyh on 2020/1/10.
 * 首頁和報表
 */
public interface MainReportService {

    //支付分析報表
    @Headers({"Domain-Name: gsa_report"})
    @POST("report/findPayMode" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<PaymentMethodBean> getPaymentInfo(@Body RequestBody requestBody);

    //銷售分析報表
    @Headers({"Domain-Name: gsa_report"})
    @GET("restaurantOperation/sales/analysis" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<SalesFoodsBean> getSalesReportInfo(@QueryMap Map<String, Object> map);

    //銷售分析報表
    @Headers({"Domain-Name: wechat_report"})
    @POST("report/findFoodTop" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<SalesFoodsBean> getSalesReportInfo(@Body RequestBody requestBody);

    //外送訂單折線圖
    @Headers({"Domain-Name: gsa_report"})
    @GET("report/delivered/getLineChart" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<DeliveryLineChartBean> getDeliveryOrderCurveInfo(@QueryMap Map<String, Object> map);

    //外送員分析
    @Headers({"Domain-Name: gsa_report"})
    @GET("report/delivered/getTakeawayReport" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<DeliveryPersonnelReportBean> getDeliveryPersonnelReport(@QueryMap Map<String, Object> map);

    //營業信息
    @Headers({"Domain-Name: gsa_report"})
    @GET("restaurantOperation/business" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<MainBusinessBean> getRestaurantReport(@Query("restaurantId") String restaurantId);

    //營業詳情
    @Headers({"Domain-Name: gsa_report"})
    @GET("restaurantOperation/business/dtails" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BusinessDetailsBean> getRestaurantDetails(@QueryMap Map<String, String> map);

    //營業金額
    @Headers({"Domain-Name: gsa_report"})
    @GET("restaurantOperation/business/amount" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<MainBusinessBean> getRestaurantAmount(@QueryMap Map<String, String> map);

    @Headers({"Domain-Name: wechat_report"})
    @POST("wx/findOrderInfoChart" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<MainOrderInfoChartBean> getOrderInfoChart(@Body RequestBody requestBody);

    //獲取首頁功能列表
    @GET("user/resource/list" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<String> getRestaurantFunList(@Query("restaurantId") String restaurantId);

    //每日營業詳情
    @Headers({"Domain-Name: gsa_report"})
    @GET("cloudGsaReport/daySalesReport" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<DaySalesReportBean> getDaySalesReport(@QueryMap Map<String, String> map);

    //賬單分析
    @Headers({"Domain-Name: gsa_report"})
    @GET("cloudGsaReport/orderAnalysis" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<OrderAnalysisBean> getOrderAnalysis(@QueryMap Map<String, String> map);

    //訂單詳情
    @Headers({"Domain-Name: gsa_report"})
    @GET("cloudGsaReport/orderDetails" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<OrderDetailsReport> getOrderDetailsReport(@QueryMap Map<String, String> map);

    //折扣詳情
    @Headers({"Domain-Name: gsa_report"})
    @GET("cloudGsaReport/discountDetails" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<DiscountDetailsReportBean> getDiscountDetails(@QueryMap Map<String, String> map);

}
