package com.gingersoft.gsa.cloud.main.mvp.ui.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.base.utils.glide.GlideUtils;
import com.gingersoft.gsa.cloud.database.bean.Function;
import com.gingersoft.gsa.cloud.main.R;

import java.util.List;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/5/12
 * 修订历史：2018/5/12
 * 描述：
 */

public class FunctionAdapter extends BaseAdapter {

    private Context mContext;
    private List<Function> mFunction;

    public FunctionAdapter(Context context, List<Function> function) {
        this.mContext = context;
        this.mFunction = function;
    }

    @Override
    public int getCount() {
        return mFunction.size();
    }

    @Override
    public Object getItem(int position) {
        return mFunction.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {

        Function dataBean = mFunction.get(position);

        ViewHolder viewholder = null;
        if (convertView == null) {
            viewholder = new ViewHolder();
            convertView = LayoutInflater.from(mContext).inflate(R.layout.main_item_function, null);
            viewholder.ll_container = convertView.findViewById(R.id.ll_container);
            viewholder.iv_image = convertView.findViewById(R.id.iv_image);
            viewholder.tv_title = convertView.findViewById(R.id.tv_title);
            convertView.setTag(viewholder);
        } else {
            viewholder = (ViewHolder) convertView.getTag();
        }

        GlideUtils.display(mContext, viewholder.iv_image, dataBean.getImageURL(), R.drawable.ic_selected_main, R.drawable.ic_selected_main, R.drawable.ic_selected_main);
        viewholder.tv_title.setText(dataBean.getResName());

        viewholder.ll_container.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (onItemClickListener != null)
                    onItemClickListener.onItemClick(position);
            }
        });
        return convertView;
    }


    private OnItemClickListener onItemClickListener;

    public void setOnItemClickListener(OnItemClickListener clickListener) {
        onItemClickListener = clickListener;
    }

    public interface OnItemClickListener {

        void onItemClick(int position);

    }

    class ViewHolder {
        private LinearLayout ll_container;
        private TextView tv_title;
        private ImageView iv_image;
    }
}
