package com.gingersoft.gsa.cloud.main.mvp.ui.adapter.foodmenu.multi;

import android.widget.RadioButton;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.FoodMenuEditBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/10/28
 * Time: 16:04
 * Use:
 */
public class RadioAdapter extends BaseQuickAdapter<FoodMenuEditBean.ShowClient, BaseViewHolder> {

    private int checkedIndex;

    public RadioAdapter(@Nullable List<FoodMenuEditBean.ShowClient> data) {
        super(R.layout.item_child_radio, data);
        addChildClickViewIds(R.id.rb_food_menu_item);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder baseViewHolder, FoodMenuEditBean.ShowClient showClient) {
        RadioButton radioButton = baseViewHolder.getView(R.id.rb_food_menu_item);
        radioButton.setText(showClient.getClientName());
        radioButton.setChecked(baseViewHolder.getAdapterPosition() == checkedIndex);
    }

    public void setCheckedIndex(int checkedIndex) {
        this.checkedIndex = checkedIndex;
    }
}
