package com.gingersoft.gsa.cloud.manager.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.gsa.cloud.manager.di.module.TableListModule;
import com.gingersoft.gsa.cloud.manager.mvp.contract.TableListContract;

import com.jess.arms.di.scope.FragmentScope;
import com.gingersoft.gsa.cloud.manager.mvp.ui.fragment.TableListFragment;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 05/20/2020 10:29
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
@Component(modules = TableListModule.class, dependencies = AppComponent.class)
public interface TableListComponent {
    void inject(TableListFragment fragment);

    @Component.Builder
    interface Builder {
        @BindsInstance
        TableListComponent.Builder view(TableListContract.View view);

        TableListComponent.Builder appComponent(AppComponent appComponent);

        TableListComponent build();
    }
}