package com.gingersoft.gsa.cloud.manager.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.account.restaurant.ResturantInfoManager;
import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.manager.mvp.model.service.TableManageService;
import com.google.gson.Gson;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import com.jess.arms.di.scope.ActivityScope;

import javax.inject.Inject;

import com.gingersoft.gsa.cloud.manager.mvp.contract.TableManageContract;

import io.reactivex.Observable;
import io.reactivex.functions.Function;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 05/13/2020 14:47
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class TableManageModel extends BaseModel implements TableManageContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public TableManageModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Observable<BaseResult> addArea(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(TableManageService.class)
                .addArea(requestBody)
                .flatMap(new Function<BaseResult, Observable<BaseResult>>() {
                    @Override
                    public Observable<BaseResult> apply(BaseResult info) throws Exception {
                        if (info != null && info.isSuccess()) {
                            return queryAreas();
                        }
                        return Observable.just(info);
                    }
                });
    }

    @Override
    public Observable<BaseResult> deleteArea(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(TableManageService.class)
                .deleteArea(requestBody)
                .flatMap(new Function<BaseResult, Observable<BaseResult>>() {
                    @Override
                    public Observable<BaseResult> apply(BaseResult info) throws Exception {
                        if (info != null && info.isSuccess()) {
                            return queryAreas();
                        }
                        return Observable.just(info);
                    }
                });
    }

    @Override
    public Observable<BaseResult> updateArea(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(TableManageService.class)
                .updateArea(requestBody)
                .flatMap(new Function<BaseResult, Observable<BaseResult>>() {
                    @Override
                    public Observable<BaseResult> apply(BaseResult info) throws Exception {
                        if (info != null && info.isSuccess()) {
                            return queryAreas();
                        }
                        return Observable.just(info);
                    }
                });
    }

    @Override
    public Observable<BaseResult> queryAreas() {
        int restaurantId = ResturantInfoManager.newInstance().getRestaurantId();
        return mRepositoryManager.obtainRetrofitService(TableManageService.class)
                .queryArea(restaurantId);
    }

    @Override
    public Observable<BaseResult> addTable(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(TableManageService.class)
                .addTable(requestBody)
                .flatMap(new Function<BaseResult, Observable<BaseResult>>() {
                    @Override
                    public Observable<BaseResult> apply(BaseResult info) throws Exception {
                        if (info != null && info.isSuccess()) {
                            return queryTables();
                        }
                        return Observable.just(info);
                    }
                });
    }

    @Override
    public Observable<BaseResult> deleteTable(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(TableManageService.class)
                .deleteTable(requestBody)
                .flatMap(new Function<BaseResult, Observable<BaseResult>>() {
                    @Override
                    public Observable<BaseResult> apply(BaseResult info) throws Exception {
                        if (info != null && info.isSuccess()) {
                            return queryTables();
                        }
                        return Observable.just(info);
                    }
                });
    }

    @Override
    public Observable<BaseResult> updateTable(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(TableManageService.class)
                .updateTable(requestBody)
                .flatMap(new Function<BaseResult, Observable<BaseResult>>() {
                    @Override
                    public Observable<BaseResult> apply(BaseResult info) throws Exception {
                        if (info != null && info.isSuccess()) {
                            return queryTables();
                        }
                        return Observable.just(info);
                    }
                });
    }

    @Override
    public Observable<BaseResult> queryTables() {
        int restaurantId = ResturantInfoManager.newInstance().getRestaurantId();
        return mRepositoryManager.obtainRetrofitService(TableManageService.class)
                .queryTable(restaurantId);
    }

    @Override
    public Observable<BaseResult> changeAreaSort(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(TableManageService.class)
                .changeAreaSort(requestBody)
                .flatMap(new Function<BaseResult, Observable<BaseResult>>() {
                    @Override
                    public Observable<BaseResult> apply(BaseResult info) throws Exception {
                        if (info != null && info.isSuccess()) {
                            return queryAreas();
                        }
                        return Observable.just(info);
                    }
                });
    }

    @Override
    public Observable<BaseResult> changeTableSort(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(TableManageService.class)
                .changeTableSort(requestBody)
                .flatMap(new Function<BaseResult, Observable<BaseResult>>() {
                    @Override
                    public Observable<BaseResult> apply(BaseResult info) throws Exception {
                        if (info != null && info.isSuccess()) {
                            return queryTables();
                        }
                        return Observable.just(info);
                    }
                });
    }

    @Override
    public Observable<BaseResult> updateTableServiceCharge(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(TableManageService.class)
                .updateTableServiceCharge(requestBody)
                .flatMap(new Function<BaseResult, Observable<BaseResult>>() {
                    @Override
                    public Observable<BaseResult> apply(BaseResult info) throws Exception {
                        if (info != null && info.isSuccess()) {
                            return queryTables();
                        }
                        return Observable.just(info);
                    }
                });
    }

}