package com.gingersoft.gsa.cloud.manager.mvp.presenter;

import android.app.Application;
import com.gingersoft.gsa.cloud.base.table.bean.TableArea;
import com.gingersoft.gsa.cloud.base.table.bean.TableManagerItem;
import com.gingersoft.gsa.cloud.manager.mvp.contract.TableListContract;
import com.gingersoft.gsa.cloud.ui.bean.view.SectionHeader;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.http.imageloader.ImageLoader;
import com.jess.arms.integration.AppManager;
import com.jess.arms.mvp.BasePresenter;
import com.qmuiteam.qmui.widget.section.QMUISection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 05/20/2020 10:29
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class TableListPresenter extends BasePresenter<TableListContract.Model, TableListContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    @Inject
    public TableListPresenter(TableListContract.Model model, TableListContract.View rootView) {
        super(model, rootView);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    /**
     * 組合餐檯區域集合
     */
    public List<TableArea> assembleTableArea(List<TableArea> areaList, List<TableManagerItem> tableList) {

        List<TableArea> tableAreaList = new ArrayList<>();

        if (areaList.size() == 0) {
            TableArea area = new TableArea();
            area.setId(-1);
            area.setRegionName("其他");
            areaList.add(area);
        }

        for (TableArea area : areaList) {
            TableArea newArea = new TableArea(area);
            List<TableManagerItem> tableItemList = new ArrayList<>();
            for (TableManagerItem table : tableList) {
                if (table.getRegionId() == area.getId()) {
                    tableItemList.add(table);
                }
            }
            newArea.setTableItemList(tableItemList);
            tableAreaList.add(newArea);
        }
        return tableAreaList;
    }

    /**
     * 組合區域集合
     */
    public List<TableArea> assembleAreaList(List<TableArea> areaList, List<TableManagerItem> tableList) {
        removeOtherAreaItem(areaList);
        if (areaList.size() > 0) {
            for (TableManagerItem table : tableList) {
                if (table.getRegionId() == -1) {
                    //將沒有區域的檯 放到其他下面
                    TableArea newArea = new TableArea();
                    newArea.setId(-1);
                    newArea.setRegionName("默認");
                    areaList.add(newArea);
                    break;
                }
            }
            return areaList;
        }
        boolean addOther = false;
        for (TableManagerItem table : tableList) {
            if (table.getRegionId() != -1) {
                if (!equalsAreaId(areaList, table.getRegionId())) {
                    TableArea newArea = new TableArea();
                    newArea.setId(table.getRegionId());
                    newArea.setRegionName(table.getRegionName());
                    areaList.add(newArea);
                }
            } else {
                addOther = true;
            }
        }
        if (addOther) {
            //將沒有區域的檯 放到其他下面
            TableArea newArea = new TableArea();
            newArea.setId(-1);
            newArea.setRegionName("默認");
            areaList.add(newArea);
        }
        return areaList;
    }

    public boolean equalsAreaId(List<TableArea> areaList, int id) {
        for (TableArea area : areaList) {
            if (area.getId() == id) {
                return true;
            }
        }
        return false;
    }

    private void removeOtherAreaItem(List<TableArea> areaList) {
        for (int i = areaList.size() - 1; i >= 0; i--) {
            if (areaList.get(i).getRegionName().equals("默認")) {
                areaList.remove(i);
            }
        }
    }

    public List<QMUISection<SectionHeader, TableManagerItem>> tableAreaTransformToSection(List<TableArea> mItems) {
        List<QMUISection<SectionHeader, TableManagerItem>> qmuiSections = new ArrayList<>();
        for (int i = 0; i < mItems.size(); i++) {
            TableArea tableArea = mItems.get(i);
            qmuiSections.add(createSection(tableArea));
        }
        return qmuiSections;
    }

    private QMUISection<SectionHeader, TableManagerItem> createSection(TableArea tableArea) {
        SectionHeader header = new SectionHeader(tableArea.getRegionName());
        ArrayList<TableManagerItem> contents = new ArrayList<>();
        if (Objects.requireNonNull(tableArea.getTableItemList().size()) > 0) {
            contents.addAll(tableArea.getTableItemList());
        }
        contents.add(createAddTableItem(tableArea));
        return new QMUISection(header, contents, false);
    }

    /**
     * 创建+按钮
     *
     * @return
     */
    private TableManagerItem createAddTableItem(TableArea tableArea) {
        TableManagerItem item = new TableManagerItem();
        item.setLayoutType(1);
        item.setStatus(0);
        item.setRegionId(tableArea.getId());
        item.setRegionName(tableArea.getRegionName());
        return item;
    }


}
