package com.gingersoft.order_advance_module.mvp.ui.activity;

import android.content.Intent;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.jess.arms.base.BaseActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;

import com.gingersoft.order_advance_module.di.component.DaggerDiningTableComponent;
import com.gingersoft.order_advance_module.di.module.DiningTableModule;
import com.gingersoft.order_advance_module.mvp.contract.DiningTableContract;
import com.gingersoft.order_advance_module.mvp.presenter.DiningTablePresenter;

import com.gingersoft.order_advance_module.R;


import static com.jess.arms.utils.Preconditions.checkNotNull;


public class DiningTableActivity extends BaseActivity<DiningTablePresenter> implements DiningTableContract.View {

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerDiningTableComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .diningTableModule(new DiningTableModule(this))
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.activity_dining_table; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

    }

    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {

    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.snackbarText(message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }




}
