package com.joe.print.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.joe.print.di.module.PrintModule;
import com.joe.print.mvp.contract.PrintContract;

import com.jess.arms.di.scope.ActivityScope;
import com.joe.print.mvp.ui.activity.PrintActivity;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 01/18/2020 14:57
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
@Component(modules = PrintModule.class, dependencies = AppComponent.class)
public interface PrintComponent {
    void inject(PrintActivity activity);

    @Component.Builder
    interface Builder {
        @BindsInstance
        PrintComponent.Builder view(PrintContract.View view);

        PrintComponent.Builder appComponent(AppComponent appComponent);

        PrintComponent build();
    }
}