package com.joe.print.di.module;

import com.jess.arms.di.scope.ActivityScope;

import dagger.Module;
import dagger.Provides;

import com.joe.print.mvp.contract.PrintAddCurrencyContract;
import com.joe.print.mvp.model.PrintAddCurrencyModel;


@Module
public class PrintAddCurrencyModule {
    private PrintAddCurrencyContract.View view;

    /**
     * 构建PrintAddCurrencyModule时,将View的实现类传进来,这样就可以提供View的实现类给presenter
     *
     * @param view
     */
    public PrintAddCurrencyModule(PrintAddCurrencyContract.View view) {
        this.view = view;
    }

    @ActivityScope
    @Provides
    PrintAddCurrencyContract.View providePrintAddCurrencyView() {
        return this.view;
    }

    @ActivityScope
    @Provides
    PrintAddCurrencyContract.Model providePrintAddCurrencyModel(PrintAddCurrencyModel model) {
        return model;
    }
}