package com.gingersoft.supply_chain.mvp.server;

import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.supply_chain.mvp.bean.MeasurementUnitBean;
import com.gingersoft.supply_chain.mvp.bean.SupplierResultBean;

import java.util.Map;

import io.reactivex.Observable;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.QueryMap;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/20
 * Time: 15:29
 * Use:
 */
public interface SupplierServer {

    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("supplier/add" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> addSupplier(@Body RequestBody requestBody);

    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("supplier/list" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<SupplierResultBean> getSupplierList(@QueryMap Map<String, Object> map);

    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("supplier/update" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> updateSupplier(@Body RequestBody requestBody);


    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("foodUnit/list" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<MeasurementUnitBean> getMeasurementUnitList(@QueryMap Map<String, Object> map);

    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("foodUnit/update" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> updateFoodUnit(@Body RequestBody requestBody);

    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("foodUnit/add" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> addFoodUnit(@Body RequestBody requestBody);
}
