package com.gingersoft.supply_chain.mvp.ui.adapter;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.MeasurementUnitBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/21
 * Time: 16:04
 * Use:
 */
public class MeasurementUnitAdapter extends BaseQuickAdapter<MeasurementUnitBean.DataBean.Unit, BaseViewHolder> {

    public MeasurementUnitAdapter(@Nullable List<MeasurementUnitBean.DataBean.Unit> data) {
        super(R.layout.item_unit, data);
        addChildClickViewIds(R.id.iv_measurement_unit_delete);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, MeasurementUnitBean.DataBean.Unit unit) {
        viewHolder.setText(R.id.tv_measurement_unit_type, MeasurementUnitBean.DataBean.Unit.measurementUnits.get(unit.getType()));
        viewHolder.setText(R.id.tv_measurement_unit, unit.getUnitContent());
        viewHolder.setText(R.id.tv_measurement_unit_remakes, unit.getRemarks());
    }
}
