package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.content.Context;

import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.listener.OnItemClickListener;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.PurchaseFunctionBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/19
 * Time: 16:28
 * Use:
 */
public class PurchaseFunctionAdapter extends BaseQuickAdapter<PurchaseFunctionBean, BaseViewHolder> {

    private Context mContext;
    private OnItemClickListener onItemClickListener;
    public PurchaseFunctionAdapter(Context context, @Nullable List<PurchaseFunctionBean> data) {
        super(R.layout.main_function_item, data);
        this.mContext = context;
    }
    public void setFunctionClickListener(OnItemClickListener onItemClickListener){
        this.onItemClickListener = onItemClickListener;
    }
    @Override
    protected void convert(@NotNull BaseViewHolder baseViewHolder, PurchaseFunctionBean purchaseFunctionBean) {
        baseViewHolder.setText(R.id.tv_purchase_function_name, purchaseFunctionBean.getFunctionName());
        RecyclerView mRvFunctionList = baseViewHolder.getView(R.id.rv_purchase_function_list_child_list);
        mRvFunctionList.setLayoutManager(new GridLayoutManager(mContext, 4));
        FunctionChildAdapter functionChildAdapter = new FunctionChildAdapter(purchaseFunctionBean.getChildFunction());
        functionChildAdapter.setOnItemClickListener((adapter, view, position) -> {
            if(onItemClickListener != null){
                onItemClickListener.onItemClick(adapter, view, position);
            }
        });
        mRvFunctionList.setAdapter(functionChildAdapter);
    }



}
