package com.gingersoft.gsa.cloud.login.mvp.ui.activity.mvp.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.widget.Button;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.utils.other.SPUtils;
import com.gingersoft.gsa.cloud.base.utils.toast.ToastUtils;
import com.gingersoft.gsa.cloud.constans.HttpsConstans;
import com.gingersoft.gsa.cloud.login.R;
import com.gingersoft.gsa.cloud.login.R2;
import com.gingersoft.gsa.cloud.login.di.component.DaggerSwitchServerComponent;
import com.gingersoft.gsa.cloud.login.mvp.contract.SwitchServerContract;
import com.gingersoft.gsa.cloud.login.mvp.presenter.SwitchServerPresenter;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;

import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 02/29/2020 20:49
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class SwitchServerActivity extends BaseActivity<SwitchServerPresenter> implements SwitchServerContract.View {

    @BindView(R2.id.radioGroup)
    RadioGroup radioGroup;
    @BindView(R2.id.rb_server_hk)
    RadioButton rbHK;
    @BindView(R2.id.rb_server_formal)
    RadioButton rbFormal;
    @BindView(R2.id.rb_youchang)
    RadioButton rb_youchang;
    @BindView(R2.id.rb_shiwei)
    RadioButton rb_shiwei;
    @BindView(R2.id.rb_shishu)
    RadioButton rb_shishu;
    @BindView(R2.id.btn_switch_server)
    Button switchServer;
    @BindView(R2.id.tv_now_server)
    TextView tvNowServer;

    private int[] rbIds = new int[]{R.id.rb_server_hk, R.id.rb_server_formal, R.id.rb_youchang, R.id.rb_shiwei, R.id.rb_shishu};

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerSwitchServerComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.activity_switch_server; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        String nowServer = HttpsConstans.ROOT_SERVER_ADDRESS_FORMAL;
        tvNowServer.setText("當前服務器：" + nowServer);

        int defaultSelect = (Integer) SPUtils.get(this, "isFormal", -1);
        if (defaultSelect == -1) {
            defaultSelect = HttpsConstans.isFormal;
        }

        ((RadioButton) radioGroup.getChildAt(defaultSelect)).setChecked(true);

        radioGroup.setOnCheckedChangeListener((group, checkedId) -> {
            SPUtils.put(mContext, "isFormal", group.indexOfChild(findViewById(checkedId)));
            ToastUtils.show(mContext, "已切換環境，下次重啟生效");
        });

//        rbHK.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
//            @Override
//            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
//                setChecked(2);
//            }
//        });
//        rbFormal.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
//            @Override
//            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
//                setChecked(1);
//            }
//        });
//        rb_youchang.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
//            @Override
//            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
//                setChecked(3);
//            }
//        });
//        rb_shiwei.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
//            @Override
//            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
//                setChecked(4);
//            }
//        });
//        rb_shishu.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
//            @Override
//            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
//                setChecked(5);
//            }
//        });
//        });
        switchServer.setOnClickListener(v -> {
//            GsaCloudApplication.initDomainUrl();
            GsaCloudApplication.isLogin = false;
//            CC.obtainBuilder("User.Component.Login")
//                    .setActionName("showActivityA")
//                    .build()
//                    .call();
//            finish();
            System.exit(0);
        });
    }

//    private void setChecked(int i) {
//        switch (i) {
//            case 1:
//                rbHK.setChecked(false);
//                rb_youchang.setChecked(false);
//                rb_shiwei.setChecked(false);
//                rb_shishu.setChecked(false);
//                rbFormal.setChecked(true);
//                break;
//            case 2:
//                rbFormal.setChecked(false);
//                rb_youchang.setChecked(false);
//                rb_shiwei.setChecked(false);
//                rb_shishu.setChecked(false);
//                rbHK.setChecked(true);
//                break;
//            case 3:
//                rbHK.setChecked(false);
//                rbFormal.setChecked(false);
//                rb_shiwei.setChecked(false);
//                rb_shishu.setChecked(false);
//                rb_youchang.setChecked(true);
//                break;
//            case 4:
//                rbHK.setChecked(false);
//                rbFormal.setChecked(false);
//                rb_youchang.setChecked(false);
//                rb_shishu.setChecked(false);
//                rb_shiwei.setChecked(true);
//                break;
//            case 5:
//                rbHK.setChecked(false);
//                rbFormal.setChecked(false);
//                rb_youchang.setChecked(false);
//                rb_shiwei.setChecked(false);
//                rb_shishu.setChecked(true);
//                break;
//        }
//        SPUtils.put(this, "isFormal", i);
//    }


    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {

    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }


    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.snackbarText(message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }
}
