package com.gingersoft.gsa.cloud.database.greendao;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "PRINTER_DEVICE_BEAN".
*/
public class PrinterDeviceBeanDao extends AbstractDao<PrinterDeviceBean, Long> {

    public static final String TABLENAME = "PRINTER_DEVICE_BEAN";

    /**
     * Properties of entity PrinterDeviceBean.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Id = new Property(0, int.class, "id", false, "ID");
        public final static Property Dbid = new Property(1, Long.class, "dbid", true, "_id");
        public final static Property Name = new Property(2, String.class, "name", false, "NAME");
        public final static Property RestaurantId = new Property(3, Integer.class, "restaurantId", false, "RESTAURANT_ID");
        public final static Property Ip = new Property(4, String.class, "ip", false, "IP");
        public final static Property Port = new Property(5, Integer.class, "port", false, "PORT");
        public final static Property Status = new Property(6, Integer.class, "status", false, "STATUS");
        public final static Property PrinterModelId = new Property(7, int.class, "printerModelId", false, "PRINTER_MODEL_ID");
        public final static Property PaperSpecification = new Property(8, String.class, "paperSpecification", false, "PAPER_SPECIFICATION");
        public final static Property PrinterName = new Property(9, String.class, "printerName", false, "PRINTER_NAME");
        public final static Property Model = new Property(10, String.class, "model", false, "MODEL");
        public final static Property PrinterDeviceId = new Property(11, Long.class, "printerDeviceId", false, "PRINTER_DEVICE_ID");
        public final static Property DefaultPrinterDeviceId = new Property(12, Long.class, "defaultPrinterDeviceId", false, "DEFAULT_PRINTER_DEVICE_ID");
    }


    public PrinterDeviceBeanDao(DaoConfig config) {
        super(config);
    }
    
    public PrinterDeviceBeanDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"PRINTER_DEVICE_BEAN\" (" + //
                "\"ID\" INTEGER NOT NULL ," + // 0: id
                "\"_id\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 1: dbid
                "\"NAME\" TEXT," + // 2: name
                "\"RESTAURANT_ID\" INTEGER," + // 3: restaurantId
                "\"IP\" TEXT," + // 4: ip
                "\"PORT\" INTEGER," + // 5: port
                "\"STATUS\" INTEGER," + // 6: status
                "\"PRINTER_MODEL_ID\" INTEGER NOT NULL ," + // 7: printerModelId
                "\"PAPER_SPECIFICATION\" TEXT," + // 8: paperSpecification
                "\"PRINTER_NAME\" TEXT," + // 9: printerName
                "\"MODEL\" TEXT," + // 10: model
                "\"PRINTER_DEVICE_ID\" INTEGER," + // 11: printerDeviceId
                "\"DEFAULT_PRINTER_DEVICE_ID\" INTEGER);"); // 12: defaultPrinterDeviceId
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"PRINTER_DEVICE_BEAN\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, PrinterDeviceBean entity) {
        stmt.clearBindings();
        stmt.bindLong(1, entity.getId());
 
        Long dbid = entity.getDbid();
        if (dbid != null) {
            stmt.bindLong(2, dbid);
        }
 
        String name = entity.getName();
        if (name != null) {
            stmt.bindString(3, name);
        }
 
        Integer restaurantId = entity.getRestaurantId();
        if (restaurantId != null) {
            stmt.bindLong(4, restaurantId);
        }
 
        String ip = entity.getIp();
        if (ip != null) {
            stmt.bindString(5, ip);
        }
 
        Integer port = entity.getPort();
        if (port != null) {
            stmt.bindLong(6, port);
        }
 
        Integer status = entity.getStatus();
        if (status != null) {
            stmt.bindLong(7, status);
        }
        stmt.bindLong(8, entity.getPrinterModelId());
 
        String paperSpecification = entity.getPaperSpecification();
        if (paperSpecification != null) {
            stmt.bindString(9, paperSpecification);
        }
 
        String printerName = entity.getPrinterName();
        if (printerName != null) {
            stmt.bindString(10, printerName);
        }
 
        String model = entity.getModel();
        if (model != null) {
            stmt.bindString(11, model);
        }
 
        Long printerDeviceId = entity.getPrinterDeviceId();
        if (printerDeviceId != null) {
            stmt.bindLong(12, printerDeviceId);
        }
 
        Long defaultPrinterDeviceId = entity.getDefaultPrinterDeviceId();
        if (defaultPrinterDeviceId != null) {
            stmt.bindLong(13, defaultPrinterDeviceId);
        }
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, PrinterDeviceBean entity) {
        stmt.clearBindings();
        stmt.bindLong(1, entity.getId());
 
        Long dbid = entity.getDbid();
        if (dbid != null) {
            stmt.bindLong(2, dbid);
        }
 
        String name = entity.getName();
        if (name != null) {
            stmt.bindString(3, name);
        }
 
        Integer restaurantId = entity.getRestaurantId();
        if (restaurantId != null) {
            stmt.bindLong(4, restaurantId);
        }
 
        String ip = entity.getIp();
        if (ip != null) {
            stmt.bindString(5, ip);
        }
 
        Integer port = entity.getPort();
        if (port != null) {
            stmt.bindLong(6, port);
        }
 
        Integer status = entity.getStatus();
        if (status != null) {
            stmt.bindLong(7, status);
        }
        stmt.bindLong(8, entity.getPrinterModelId());
 
        String paperSpecification = entity.getPaperSpecification();
        if (paperSpecification != null) {
            stmt.bindString(9, paperSpecification);
        }
 
        String printerName = entity.getPrinterName();
        if (printerName != null) {
            stmt.bindString(10, printerName);
        }
 
        String model = entity.getModel();
        if (model != null) {
            stmt.bindString(11, model);
        }
 
        Long printerDeviceId = entity.getPrinterDeviceId();
        if (printerDeviceId != null) {
            stmt.bindLong(12, printerDeviceId);
        }
 
        Long defaultPrinterDeviceId = entity.getDefaultPrinterDeviceId();
        if (defaultPrinterDeviceId != null) {
            stmt.bindLong(13, defaultPrinterDeviceId);
        }
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 1) ? null : cursor.getLong(offset + 1);
    }    

    @Override
    public PrinterDeviceBean readEntity(Cursor cursor, int offset) {
        PrinterDeviceBean entity = new PrinterDeviceBean( //
            cursor.getInt(offset + 0), // id
            cursor.isNull(offset + 1) ? null : cursor.getLong(offset + 1), // dbid
            cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2), // name
            cursor.isNull(offset + 3) ? null : cursor.getInt(offset + 3), // restaurantId
            cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4), // ip
            cursor.isNull(offset + 5) ? null : cursor.getInt(offset + 5), // port
            cursor.isNull(offset + 6) ? null : cursor.getInt(offset + 6), // status
            cursor.getInt(offset + 7), // printerModelId
            cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8), // paperSpecification
            cursor.isNull(offset + 9) ? null : cursor.getString(offset + 9), // printerName
            cursor.isNull(offset + 10) ? null : cursor.getString(offset + 10), // model
            cursor.isNull(offset + 11) ? null : cursor.getLong(offset + 11), // printerDeviceId
            cursor.isNull(offset + 12) ? null : cursor.getLong(offset + 12) // defaultPrinterDeviceId
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, PrinterDeviceBean entity, int offset) {
        entity.setId(cursor.getInt(offset + 0));
        entity.setDbid(cursor.isNull(offset + 1) ? null : cursor.getLong(offset + 1));
        entity.setName(cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2));
        entity.setRestaurantId(cursor.isNull(offset + 3) ? null : cursor.getInt(offset + 3));
        entity.setIp(cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4));
        entity.setPort(cursor.isNull(offset + 5) ? null : cursor.getInt(offset + 5));
        entity.setStatus(cursor.isNull(offset + 6) ? null : cursor.getInt(offset + 6));
        entity.setPrinterModelId(cursor.getInt(offset + 7));
        entity.setPaperSpecification(cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8));
        entity.setPrinterName(cursor.isNull(offset + 9) ? null : cursor.getString(offset + 9));
        entity.setModel(cursor.isNull(offset + 10) ? null : cursor.getString(offset + 10));
        entity.setPrinterDeviceId(cursor.isNull(offset + 11) ? null : cursor.getLong(offset + 11));
        entity.setDefaultPrinterDeviceId(cursor.isNull(offset + 12) ? null : cursor.getLong(offset + 12));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(PrinterDeviceBean entity, long rowId) {
        entity.setDbid(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(PrinterDeviceBean entity) {
        if(entity != null) {
            return entity.getDbid();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(PrinterDeviceBean entity) {
        return entity.getDbid() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
}
