package com.gingersoft.gsa.cloud.main.mvp.presenter;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.constans.AppConstant;
import com.gingersoft.gsa.cloud.common.core.restaurant.RestaurantInfoManager;
import com.gingersoft.gsa.cloud.common.core.settlement.SettlementReport;
import com.gingersoft.gsa.cloud.common.utils.CollectionUtils;
import com.gingersoft.gsa.cloud.common.utils.JsonUtils;
import com.gingersoft.gsa.cloud.common.utils.gson.GsonUtils;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.main.mvp.contract.LiquidationHistoryContract;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.SettlementHistoryListBean;
import com.gingersoft.gsa.cloud.main.mvp.ui.activity.SettlementActivity;
import com.gingersoft.gsa.cloud.main.mvp.ui.adapter.LiquidationHistoryAdapter;
import com.gingersoft.gsa.cloud.ui.animator.CustomAnimation3;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.http.imageloader.ImageLoader;
import com.jess.arms.integration.AppManager;
import com.jess.arms.mvp.BasePresenter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.inject.Inject;

import io.reactivex.annotations.NonNull;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.ErrorHandleSubscriber;


/**
 * ================================================
 * Description:清機歷史記錄
 */
@ActivityScope
public class LiquidationHistoryPresenter extends BasePresenter<LiquidationHistoryContract.Model, LiquidationHistoryContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    private LiquidationHistoryAdapter liquidationHistoryAdapter;

    @Inject
    public LiquidationHistoryPresenter(LiquidationHistoryContract.Model model, LiquidationHistoryContract.View rootView) {
        super(model, rootView);
    }

    public void initAdapter() {
        liquidationHistoryAdapter = new LiquidationHistoryAdapter(null);
        liquidationHistoryAdapter.setAdapterAnimation(new CustomAnimation3());
        mRootView.setAdapter(liquidationHistoryAdapter);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    public void getLiquidationHistory(int pageIndex, String startTime, String endTime) {
        Map<String, Object> map = new HashMap<>(6);
        AppConstant.addRestaurantId(map);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("type", SettlementActivity.SETTLEMENT_TYPE_NOMAL);
        AppConstant.addPageIndex(map, pageIndex);
        AppConstant.addPageSize(map);
        sendRequest(mModel.getLiquidationHistory(map), AppConstant.GET_INFO_LOADING)
                .subscribe(new ErrorHandleSubscriber<BaseResult>(mErrorHandler) {
                    @Override
                    public void onNext(BaseResult baseResult) {
                        if (baseResult.isSuccess()) {
                            List<SettlementHistoryListBean> historyListBeans = GsonUtils.jsonToList(baseResult.getData(), SettlementHistoryListBean.class);
                            if (CollectionUtils.isNotNullOrEmpty(historyListBeans)) {
                                if (pageIndex == 0) {
                                    liquidationHistoryAdapter.setList(historyListBeans);
                                } else {
                                    liquidationHistoryAdapter.addData(historyListBeans);
                                }
                                mRootView.finisLoad();
                            } else if (pageIndex > 0 && liquidationHistoryAdapter.getItemCount() > 0) {
                                mRootView.setLoadNoMoreData();
                            } else {
                                mRootView.setNoData();
                            }
                        } else if (TextUtil.isNotEmptyOrNullOrUndefined(baseResult.getErrMsg())) {
                            mRootView.showMessage(baseResult.getErrMsg());
                        } else {
                            mRootView.showMessage(AppConstant.GET_INFO_ERROR);
                        }
                    }
                });
    }


    public void getSettlementReport(String startTime, String endTime) {
        int restaurantId = RestaurantInfoManager.newInstance().getRestaurantId();
        sendRequest(mModel.getSettlementReport(restaurantId, startTime, endTime), AppConstant.GET_INFO_LOADING)
                .subscribe(new ErrorHandleSubscriber<BaseResult>(mErrorHandler) {
                    @Override
                    public void onNext(@NonNull BaseResult info) {
                        if (info != null && info.isSuccess()) {
                            if (info.getData() != null) {
                                SettlementReport settlementReport = JsonUtils.parseObject(info.getData(), SettlementReport.class);
                                if (settlementReport != null) {
                                    mRootView.toSettlementReportActivity(settlementReport);
                                    return;
                                }
                            }
                        }
                        mRootView.showMessage(AppConstant.GET_INFO_ERROR);
                    }
                });
    }

}
