package com.joe.print.mvp.presenter;

import android.app.Application;
import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.utils.JsonUtils;
import com.gingersoft.gsa.cloud.database.bean.PrintCurrencyBean;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.http.imageloader.ImageLoader;
import com.jess.arms.integration.AppManager;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.utils.RxLifecycleUtils;
import com.joe.print.mvp.contract.LocalPrintContract;
import java.util.List;
import javax.inject.Inject;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.ErrorHandleSubscriber;
import okhttp3.MediaType;
import okhttp3.RequestBody;


@FragmentScope
public class LocalPrintPresenter extends BasePresenter<LocalPrintContract.Model, LocalPrintContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    @Inject
    public LocalPrintPresenter(LocalPrintContract.Model model, LocalPrintContract.View rootView) {
        super(model, rootView);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    public void getPrinterCurrencyList(int restaurant) {
        mModel.getPrinterCurrencyList(restaurant + "")
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(""))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<BaseResult>(mErrorHandler) {
                    @Override
                    public void onNext(BaseResult baseResult) {
                        if (baseResult != null) {

                            List<PrintCurrencyBean> printCurrencyBeans = JsonUtils.parseArray(baseResult.getData(), PrintCurrencyBean.class);
                            mRootView.loadView(printCurrencyBeans);
                        } else {
                            mRootView.loadView(null);
                        }
                    }
                });
    }


    public void deletePrinterCurrency(PrintCurrencyBean printCurrencyBean) {
        RequestBody requestBody = RequestBody.create(MediaType.parse("application/json"), JsonUtils.toJson(printCurrencyBean));
        mModel.deletePrinterCurrency(requestBody)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(""))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<BaseResult>(mErrorHandler) {
                    @Override
                    public void onNext(BaseResult s) {
                        if (s != null) {
//                            mRootView.addSuccess(s.isSuccess());
//                        } else {
//                            mRootView.addSuccess(false);
                        }
                    }
                });
    }

}
