package com.joe.print.mvp.ui.view;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;

import com.airbnb.lottie.LottieAnimationView;
import com.gingersoft.gsa.cloud.ui.widget.dialog.BaseRetryDialog;
import com.joe.print.R;
import com.qmuiteam.qmui.layout.QMUILinearLayout;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-03-28
 * 修订历史：2020-03-28
 * 描述：打印進度彈窗
 *
 * @author admin
 */
public class PrinterLoadingDialog extends BaseRetryDialog {

    private static final String TAG = "PrinterLoadingDialog";
    private Context mContext;
    private TextView tvGeneratePrintData, tvConnecting, tvPrintResult, tvErrorMsg;

    public static final byte STATUS_DEFAULT = 0;
    public static final byte STATUS_SUCCESS = 1;
    public static final byte STATUS_ERROR = 2;

    public static final byte PROGRESS_CONNECTING = 1;
    public static final byte PROGRESS_PRINTING = 2;
    public static final byte PROGRESS_RESULT = 3;

    private int mRadius;
    /**
     * 結果樣式
     */
    private Drawable[] drawables;
    /**
     * 進度顯示文字
     */
    private TextView[] textViews;

    public PrinterLoadingDialog(@NonNull Context context) {
        super(context, R.style.MyDialogTheme2);
        mContext = context;
        mRadius = QMUIDisplayHelper.dp2px(mContext, 8);
        drawables = new Drawable[3];
        drawables[0] = getDrawableByResId(R.drawable.print_grey_point);
        drawables[1] = getDrawableByResId(R.drawable.print_green_point);
        drawables[2] = getDrawableByResId(R.drawable.print_red_point);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setCanceledOnTouchOutside(true);
    }

    @Override
    public void show() {
        super.show();
    }

    @Override
    public void dismiss() {
        super.dismiss();
    }

    public PrinterLoadingDialog build() {
        View contentView = buildViews();
        int screenWidth = (int) (QMUIDisplayHelper.getScreenWidth(mContext) * 0.9);
        int screenHeight = (int) (QMUIDisplayHelper.getScreenHeight(mContext) * 0.5);
        setContentView(contentView, new LinearLayout.LayoutParams(screenWidth, screenHeight));
        return this;
    }

    private View buildViews() {
        View view = View.inflate(mContext, getContentViewLayoutId(), null);
        QMUILinearLayout llContainer = view.findViewById(R.id.ll_container);
        LottieAnimationView printLottieView = view.findViewById(R.id.lottieAnimationView);
        tvGeneratePrintData = view.findViewById(R.id.tv_generate_print_data);
        tvConnecting = view.findViewById(R.id.tv_connecting);
        tvPrintResult = view.findViewById(R.id.tv_print_result);
        tvErrorMsg = view.findViewById(R.id.tv_error_msg);
        textViews = new TextView[]{tvGeneratePrintData, tvConnecting, tvPrintResult};

        float mShadowAlpha = 0.25f;
        int mShadowElevationDp = 14;

        llContainer.setRadiusAndShadow(mRadius, QMUIDisplayHelper.dp2px(mContext, mShadowElevationDp), mShadowAlpha);

        printLottieView.setAnimation(R.raw.printer_loading3);
        printLottieView.setRepeatCount(ValueAnimator.INFINITE);
        printLottieView.playAnimation();//播放动画
        return view;
    }

    public void setStep(int step, int status, String errorMsg) {
        tvGeneratePrintData.post(() -> {
            if (!TextUtils.isEmpty(errorMsg)) {
                tvErrorMsg.setText(errorMsg);
                tvErrorMsg.setVisibility(View.VISIBLE);
            } else {
                tvErrorMsg.setVisibility(View.GONE);
            }
            //根據狀態修改顯示顏色
            if (step == PROGRESS_PRINTING) {
                setCompoundDrawableByStatus(STATUS_SUCCESS, tvGeneratePrintData);
                setCompoundDrawableByStatus(status, tvConnecting);
            } else {
                setCompoundDrawableByStatus(status, textViews[step - 1]);
            }
            //設置結果
            setStatusResult(step, status);
        });
    }

    private void setStatusResult(int step, int status) {
        switch (step) {
            case PrinterLoadingDialog.PROGRESS_PRINTING:
                tvGeneratePrintData.setText("生成成功");
                if (status == STATUS_SUCCESS) {
                    tvConnecting.setText("連接成功");
                } else if (status == STATUS_ERROR) {
                    tvConnecting.setText("連接失敗");
                } else {
                    tvConnecting.setText("連接中");
                }
                break;
            case PrinterLoadingDialog.PROGRESS_RESULT:
                if (status == STATUS_SUCCESS) {
                    tvConnecting.setText("打印成功");
                } else if (status == STATUS_ERROR) {
                    tvConnecting.setText("打印失敗");
                } else {
                    tvConnecting.setText("打印結果");
                }
                break;
            default:
                break;
        }
    }

    private void setCompoundDrawableByStatus(int status, TextView textView) {
        textView.setCompoundDrawablesWithIntrinsicBounds(textView.getCompoundDrawables()[0], drawables[status], textView.getCompoundDrawables()[2], textView.getCompoundDrawables()[0]);
    }

    private Drawable getDrawableByResId(int resId) {
        return ContextCompat.getDrawable(mContext, resId);
    }

    protected int getContentViewLayoutId() {
        return R.layout.print_dialog_loading;
    }
}
