package com.gingersoft.gsa.cloud.table.mvp.action.order;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;

import com.billy.cc.core.component.CC;
import com.gingersoft.gsa.cloud.common.constans.PrintConstans;
import com.gingersoft.gsa.cloud.common.core.table.TableBean;
import com.gingersoft.gsa.cloud.common.patterns.Strategy;
import com.gingersoft.gsa.cloud.common.utils.AppDevices;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.component.ComponentName;
import com.gingersoft.gsa.cloud.order.bean.response.OrderResponse;
import com.gingersoft.gsa.cloud.order.cart.ShoppingCart;
import com.gingersoft.gsa.cloud.order.commodity.OrderDetail;
import com.gingersoft.gsa.cloud.order.order.DoshokuOrder;
import com.gingersoft.gsa.cloud.pay.bean.PayMethod;
import com.gingersoft.gsa.cloud.pay.pos.OnPosActionListener;
import com.gingersoft.gsa.cloud.pay.pos.PosPay;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.pos.HywebPosResponse;
import com.gingersoft.gsa.cloud.print.bean.PrintContent;
import com.gingersoft.gsa.cloud.print.bean.adapter.PrintContentAdapter;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.response.OrderManagerResponse;
import com.gingersoft.gsa.cloud.table.mvp.model.utils.OrderAssemblyUtil;
import com.gingersoft.gsa.cloud.table.mvp.ui.activity.MealStandActivity;
import com.gingersoft.gsa.cloud.table.mvp.ui.activity.orderManager.OrderCenterActivity;
import com.jess.arms.base.BaseFragmentActivity;
import com.jess.arms.base.delegate.IActivity;
import com.jess.arms.mvp.IView;

import java.util.Date;
import java.util.List;

/**
 * @作者: bin
 * @創建時間: 2021-01-15 15:19
 * @更新時間: 2021-01-15 15:19
 * @描述:修改订单
 */
public class ModifyOrderAction implements Strategy<OrderManagerResponse> {

    private final  String TAG = "ModifyOrderAction";
    private BaseFragmentActivity mActivity;
    private IView mRootView;

    public ModifyOrderAction(BaseFragmentActivity fragmentActivity, IView rootView){
        this.mActivity  = fragmentActivity;
        this.mRootView = rootView;
    }

    @Override
    public void action(OrderManagerResponse orderItem) {
        DoshokuOrder doshokuOrder = DoshokuOrder.getInstance();
        //設置為修改訂單操作
        doshokuOrder.setModifyOrder(true);
        /**
         * 緩存訂單信息
         */
        OrderResponse orderBean = new OrderResponse();
        orderBean.setId(orderItem.getId());
        orderBean.setStatus(orderItem.getStatus());
        orderBean.setOrderNo(orderItem.getOrderNo());
        orderBean.setPerson(orderItem.getPerson());
        orderBean.setCreateTime(orderItem.getCreateTime());
        if (orderItem.getDiscountDetails() != null) {
            orderBean.setDiscountDetails(orderItem.getDiscountDetails());
        }
        doshokuOrder.setOrderId(orderItem.getId());
        doshokuOrder.setOrderPlaced(orderBean);

        TableBean.DataBean tableBean = new TableBean.DataBean(orderItem.getRestaurantTable());
        if (!TextUtils.isEmpty(tableBean.getTableNumber())) {
            tableBean.setTableName(tableBean.getTableName() + "-" + tableBean.getTableNumber());
        } else {
            tableBean.setTableName(tableBean.getTableName());
        }
        tableBean.setId(orderItem.getTableId());
        tableBean.setPerson(orderItem.getPerson());
        doshokuOrder.setOpenTableInfo(tableBean);

        List<OrderResponse.OrderDetailsBean> orderDetailsBeans = orderItem.getOrderDetails();
        List<OrderDetail> orderDetailList = OrderAssemblyUtil.assemblyOrder(OrderDetail.orderTransOrderDetails(orderDetailsBeans));
        doshokuOrder.getShoppingCart().addCommodityList(orderDetailList);

        if (orderItem.getMemberInfo() != null) {
            doshokuOrder.setMemberInfo(orderItem.getMemberInfo());
        }

        Intent intent = new Intent(mActivity, MealStandActivity.class);
        mActivity.startActivityForResult(intent, OrderCenterActivity.MODIFY_ORDER_RETURN_CODE);
    }

    @Override
    public void destroy() {
        mActivity = null;
        mRootView = null;
    }

}
