package com.gingersoft.gsa.cloud.ui.adapter.multi;

import androidx.appcompat.widget.SwitchCompat;

import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.ui.R;
import com.gingersoft.gsa.cloud.ui.adapter.bean.InfoMultiBean;

import org.jetbrains.annotations.NotNull;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/10/28
 * Time: 11:54
 */
public class BooleanItemProvider<T extends InfoMultiBean> extends MyBaseItemProvider<T> {

    @Override
    public int getItemViewType() {
        return InfoMultiBean.ITEM_MULTIPLE_BOOLEAN;
    }

    @Override
    public int getLayoutId() {
        return R.layout.multi_item_boolean;
    }

    @Override
    public void convert(@NotNull BaseViewHolder baseViewHolder, T infoMultiBean) {
        super.convert(baseViewHolder, infoMultiBean);
        SwitchCompat sw = baseViewHolder.getView(R.id.switch_multi_boolean_state);
        sw.setChecked(infoMultiBean.isChecked());
        sw.setOnCheckedChangeListener((buttonView, isChecked) -> infoMultiBean.setChecked(isChecked));
    }
}
