package com.gingersoft.gsa.cloud.table.mvp.ui.adapter;

import android.view.Gravity;
import android.widget.TextView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.gingersoft.gsa.cloud.base.common.bean.OrderDetail;
import com.gingersoft.gsa.cloud.table.R;

import java.util.List;

import androidx.annotation.Nullable;

public class OrderDetailPayMethodAdapter extends BaseQuickAdapter<OrderDetail, BaseViewHolder> {

    public OrderDetailPayMethodAdapter(@Nullable List<OrderDetail> data) {
        super(R.layout.item_order_detail_pay_method, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, OrderDetail item) {
        helper.setText(R.id.tv_name, String.valueOf(item.getNumber()));
        helper.setText(R.id.tv_money, "$" + item.getPrice() * item.getNumber());
    }

}
