package com.gingersoft.gsa.cloud.table.mvp.ui.adapter;

import android.content.Context;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.base.utils.LanguageUtils;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.OrderDetailItem;
import com.jess.arms.base.BaseHolder;
import com.jess.arms.base.DefaultAdapter;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;

import java.util.List;

import butterknife.BindView;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/6/27
 * 修订历史：2018/6/27
 * 描述：
 */
public class OrderCenterAdapter extends DefaultAdapter<OrderDetailItem> {

    private Context mContext;

    public OrderCenterAdapter(Context context, List<OrderDetailItem> infos) {
        super(infos);
        this.mContext = context;
    }

    @Override
    public int getItemCount() {
        return mInfos.size();
    }

    @Override
    public BaseHolder<OrderDetailItem> getHolder(View v, int viewType) {
        return new OrderCenterItemHolder(v);
    }

    @Override
    public int getLayoutId(int viewType) {
        return R.layout.item_order_center;
    }

    class OrderCenterItemHolder extends BaseHolder<OrderDetailItem> {

        @BindView(R2.id.ll_root_container)
        LinearLayout ll_root_container;
        @BindView(R2.id.tv_table_name)
        TextView tv_table_name;
        @BindView(R2.id.tv_order_num)
        TextView tv_order_num;
        @BindView(R2.id.tv_people_num)
        TextView tv_people_num;
        @BindView(R2.id.tv_open_time)
        TextView tv_open_time;
        @BindView(R2.id.tv_pay_time)
        TextView tv_pay_time;
        @BindView(R2.id.tv_pay_money)
        TextView tv_pay_money;

        @BindView(R2.id.btn_print_order)
        QMUIAlphaButton btn_print_order;
        @BindView(R2.id.btn_tips)
        QMUIAlphaButton btn_tips;
        @BindView(R2.id.btn_refund)
        QMUIAlphaButton btn_refund;
        @BindView(R2.id.btn_modify_order)
        QMUIAlphaButton btn_modify_order;
        @BindView(R2.id.btn_cancel_order)
        QMUIAlphaButton btn_cancel_order;
        @BindView(R2.id.btn_order_status)
        QMUIAlphaButton btn_order_status;
        @BindView(R2.id.ll_bottom)
        LinearLayout ll_bottom;

        public OrderCenterItemHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void setData(OrderDetailItem datasBean, int position) {

            String tableName = LanguageUtils.get_language_system(mContext, "table.number", "檯號") + "：";
            String pax = LanguageUtils.get_language_system(mContext, "Meal.Mannumber", "人數") + "：";
            String orderNumber = LanguageUtils.get_language_system(mContext, "order.number", "訂單號") + "：";
            String openTable = LanguageUtils.get_language_system(mContext, "open.table", "開台") + "：";
            String amount = LanguageUtils.get_language_system(mContext, "amount", "金額") + "：$";

            tv_table_name.setText(tableName + datasBean.getId());
            tv_order_num.setText(orderNumber + datasBean.getOrderNo());
            tv_people_num.setText(pax + datasBean.getPerson());
            tv_open_time.setText(openTable + datasBean.getCreateTime());
            tv_pay_money.setText(amount + datasBean.getTotalAmount());

            btn_print_order.setText(LanguageUtils.get_language_system(mContext, "print.order", "打印賬單"));
            btn_tips.setText(LanguageUtils.get_language_system(mContext, "public.tips", "貼士"));
            btn_modify_order.setText(LanguageUtils.get_language_system(mContext, "modify.order", "修改訂單"));
            btn_cancel_order.setText(LanguageUtils.get_language_system(mContext, "cancel.order", "取消訂單"));

        }
    }

}
