package com.gingersoft.gsa.cloud.table.mvp.ui.adapter;

import android.view.Gravity;
import android.widget.TextView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.common.bean.OrderDetail;
import com.gingersoft.gsa.cloud.base.common.bean.PayMethod;
import com.gingersoft.gsa.cloud.base.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.OrderDetailItem;

import java.util.List;

import androidx.annotation.Nullable;

public class OrderDetailFoodAdapter extends BaseQuickAdapter<OrderDetail, BaseViewHolder> {

    public OrderDetailFoodAdapter(@Nullable List<OrderDetail> data) {
        super(R.layout.item_order_detail_food, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, OrderDetail item) {
        TextView tv_food_name = helper.getView(R.id.tv_food_name);
        int flevel = item.getItemType();
        String productName = item.getProductName();
        switch (flevel) {
            case 1:
                tv_food_name.setGravity(Gravity.LEFT);
                break;
            case 2:
                productName = "  " + productName;
                tv_food_name.setGravity(Gravity.CENTER);
                break;
            case 3:
                productName = "   " + productName;
                tv_food_name.setGravity(Gravity.RIGHT);
                break;
        }
        tv_food_name.setText(productName);
        helper.setText(R.id.tv_food_number, String.valueOf(item.getNumber()));
        helper.setText(R.id.tv_food_total, "$" + item.getPrice() * item.getNumber());
    }

}
