/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epos2.printer;

import android.util.Pair;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

class RcxHeaderAnalyzer {
    static final byte FF = 12;
    static final byte CR = 13;
    private boolean m_valid = false;
    private Map<String, Map<Integer, Element>> m_elementTree = new TreeMap<String, Map<Integer, Element>>();

    public RcxHeaderAnalyzer(InputStream inputStream) {
        this.m_valid = this.analyze(inputStream);
    }

    public RcxHeaderAnalyzer(String filename) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        this.m_valid = this.analyze(inputStream);
        try {
            ((InputStream)inputStream).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Pair<Boolean, String> enumTag(String string) {
        char c;
        int elementStart;
        int elementEnd = string.length() - 1;
        for (elementStart = 0; elementStart < string.length(); ++elementStart) {
            c = string.charAt(elementStart);
            if (c == ' ' || c == '\t') continue;
            if (c == '[') break;
            return new Pair((Object)false, (Object)"");
        }
        while (elementEnd >= 0) {
            c = string.charAt(elementEnd);
            if (c != ' ' && c != '\t') {
                if (c == ']') break;
                return new Pair((Object)false, (Object)"");
            }
            --elementEnd;
        }
        if (elementStart + 1 < elementEnd) {
            return new Pair((Object)true, (Object)string.substring(elementStart + 1, elementEnd));
        }
        return new Pair((Object)false, (Object)"");
    }

    private boolean putElement(String category, String line) {
        char c;
        int index;
        LinkedList<Integer> id = new LinkedList<Integer>();
        int number = 0;
        for (index = 0; index < line.length(); ++index) {
            c = line.charAt(index);
            if (c == ' ' || c == '\t') continue;
            if (Character.isDigit(c)) {
                number = 10 * number + (c - 48);
                continue;
            }
            if (c == '.') {
                id.addLast(number);
                number = 0;
                continue;
            }
            if (c == '=') {
                id.addLast(number);
                ++index;
                break;
            }
            return false;
        }
        if (id.isEmpty() || index >= line.length()) {
            return false;
        }
        while (index < line.length()) {
            c = line.charAt(index);
            if (c != ' ' && c != '\t') {
                if (c == '\"') {
                    ++index;
                    break;
                }
                return false;
            }
            ++index;
        }
        if (index >= line.length()) {
            return false;
        }
        boolean lastCharIsBackSlash = false;
        String data = "";
        while (index < line.length()) {
            char c2 = line.charAt(index);
            if (lastCharIsBackSlash) {
                data = data + c2;
                lastCharIsBackSlash = false;
            } else if (c2 == '\\') {
                lastCharIsBackSlash = true;
            } else {
                if (c2 == '\"') break;
                data = data + c2;
            }
            ++index;
        }
        if (!this.m_elementTree.containsKey(category)) {
            this.m_elementTree.put(category, new TreeMap());
        }
        Map<Integer, Element> currentParent = this.m_elementTree.get(category);
        Element currentElement = null;
        do {
            int subId = (Integer)id.getFirst();
            id.removeFirst();
            if (!currentParent.containsKey(subId)) {
                currentElement = new Element();
                currentParent.put(subId, currentElement);
            } else {
                currentElement = currentParent.get(subId);
            }
            currentParent = currentParent.get((Object)Integer.valueOf((int)subId)).children;
        } while (!id.isEmpty());
        currentElement.element = data;
        return true;
    }

    private boolean analyzeByteArray(byte[] data) {
        try {
            String wholeString = new String(data, "US-ASCII");
            String[] lines = wholeString.split("\n");
            String category = null;
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                Pair<Boolean, String> tag = this.enumTag(line);
                boolean isTag = (Boolean)tag.first;
                String tagString = (String)tag.second;
                if (isTag) {
                    category = tagString;
                    continue;
                }
                if (category == null) continue;
                this.putElement(category, line);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
        catch (OutOfMemoryError e) {
            return false;
        }
        return true;
    }

    private boolean analyze(InputStream inputStream) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int readByte = 0;
            try {
                while ((readByte = inputStream.read()) != -1) {
                    byte b = (byte)(readByte & 0xFF);
                    if (b == 12) {
                        return this.analyzeByteArray(byteArrayOutputStream.toByteArray());
                    }
                    if (b == 13) continue;
                    byteArrayOutputStream.write(readByte);
                }
                this.m_valid = false;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.m_valid = false;
            }
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (OutOfMemoryError e) {
            this.m_valid = false;
        }
        return true;
    }

    public boolean valid() {
        return this.m_valid;
    }

    public String get(String category, String key) {
        String[] stringKeyArray = key.split("\\.");
        if (stringKeyArray.length == 0) {
            stringKeyArray = new String[]{key};
        }
        int[] intKeyArray = new int[stringKeyArray.length];
        for (int i = 0; i < stringKeyArray.length; ++i) {
            try {
                intKeyArray[i] = Integer.parseInt(stringKeyArray[i]);
                continue;
            }
            catch (NumberFormatException e) {
                return "";
            }
        }
        return this.get(category, intKeyArray);
    }

    public String get(String category, int[] key) {
        if (!this.m_elementTree.containsKey(category)) {
            return "";
        }
        Map<Integer, Element> currentParent = null;
        currentParent = this.m_elementTree.get(category);
        Element currentElement = null;
        for (int i = 0; i < key.length; ++i) {
            if (!currentParent.containsKey(key[i])) {
                return "";
            }
            currentElement = currentParent.get(key[i]);
            currentParent = currentElement.children;
        }
        return currentElement.element;
    }

    public int getChildrenSize(String category, String key) {
        String[] stringKeyArray = key.split("\\.");
        if (stringKeyArray.length == 0) {
            stringKeyArray = new String[]{key};
        }
        int[] intKeyArray = new int[stringKeyArray.length];
        for (int i = 0; i < stringKeyArray.length; ++i) {
            try {
                intKeyArray[i] = Integer.parseInt(stringKeyArray[i]);
                continue;
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return this.getChildrenSize(category, intKeyArray);
    }

    public int getChildrenSize(String category, int[] key) {
        if (!this.m_elementTree.containsKey(category)) {
            return 0;
        }
        Map<Integer, Element> currentParent = null;
        currentParent = this.m_elementTree.get(category);
        Element currentElement = null;
        for (int i = 0; i < key.length; ++i) {
            if (!currentParent.containsKey(key[i])) {
                return 0;
            }
            currentElement = currentParent.get(key[i]);
            currentParent = currentElement.children;
        }
        return currentElement.children.size();
    }

    public int[] getChildrenKeys(String category, String key) {
        String[] stringKeyArray = key.split("\\.");
        if (stringKeyArray.length == 0) {
            stringKeyArray = new String[]{key};
        }
        int[] intKeyArray = new int[stringKeyArray.length];
        for (int i = 0; i < stringKeyArray.length; ++i) {
            try {
                intKeyArray[i] = Integer.parseInt(stringKeyArray[i]);
                continue;
            }
            catch (NumberFormatException e) {
                return new int[0];
            }
        }
        return this.getChildrenKeys(category, intKeyArray);
    }

    public int[] getChildrenKeys(String category, int[] key) {
        if (!this.m_elementTree.containsKey(category)) {
            return new int[0];
        }
        Map<Integer, Element> currentParent = null;
        currentParent = this.m_elementTree.get(category);
        Element currentElement = null;
        for (int i = 0; i < key.length; ++i) {
            if (!currentParent.containsKey(key[i])) {
                return new int[0];
            }
            currentElement = currentParent.get(key[i]);
            currentParent = currentElement.children;
        }
        int[] childrenKeys = new int[currentElement.children.size()];
        int i = 0;
        for (Integer integer : currentElement.children.keySet()) {
            childrenKeys[i] = integer;
            ++i;
        }
        return childrenKeys;
    }

    private class Element {
        public String element = "";
        public Map<Integer, Element> children = new TreeMap<Integer, Element>();

        private Element() {
        }
    }
}

