package com.gingersoft.gsa.cloud.globalconfig.applyOptions;

import android.content.Context;

import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.jess.arms.di.module.ClientModule;

import java.util.concurrent.TimeUnit;

import me.jessyan.progressmanager.ProgressManager;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.OkHttpClient;

/**
 * autour: 宁斌
 * date: 2018/4/3 14:47
 * update: 2018/4/3 14:47
 * description:
 */

public class MyOkhttpConfiguration implements ClientModule.OkhttpConfiguration {

    @Override
    public void configOkhttp(Context context, OkHttpClient.Builder builder) {
//        builder.sslSocketFactory(); //支持 Https,详情请百度
        builder.connectTimeout(GsaCloudApplication.CONNECT_TIMEOUT, TimeUnit.SECONDS);
        builder.writeTimeout(GsaCloudApplication.REQUEST_TIMEOUT, TimeUnit.SECONDS);
        builder.readTimeout(GsaCloudApplication.REQUEST_TIMEOUT, TimeUnit.SECONDS);
        //使用一行代码监听 Retrofit／Okhttp 上传下载进度监听,以及 Glide 加载进度监听 详细使用方法查看 https://github.com/JessYanCoding/ProgressManager
        ProgressManager.getInstance().with(builder);
        //让 Retrofit 同时支持多个 BaseUrl 以及动态改变 BaseUrl. 详细使用请方法查看 https://github.com/JessYanCoding/RetrofitUrlManager
        RetrofitUrlManager.getInstance().with(builder).build();
    }
}
