package com.gingersoft.gsa.cloud.greendao;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import com.gingersoft.gsa.cloud.database.bean.ExpandInfo;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "EXPAND_INFO".
*/
public class ExpandInfoDao extends AbstractDao<ExpandInfo, Long> {

    public static final String TABLENAME = "EXPAND_INFO";

    /**
     * Properties of entity ExpandInfo.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property RestaurantId = new Property(1, Integer.class, "restaurantId", false, "RESTAURANT_ID");
        public final static Property SettingName = new Property(2, String.class, "settingName", false, "SETTING_NAME");
        public final static Property ValueInt = new Property(3, Integer.class, "valueInt", false, "VALUE_INT");
        public final static Property ValueChar = new Property(4, String.class, "valueChar", false, "VALUE_CHAR");
        public final static Property ValueBoolean = new Property(5, Boolean.class, "valueBoolean", false, "VALUE_BOOLEAN");
        public final static Property ValueDatetime = new Property(6, String.class, "valueDatetime", false, "VALUE_DATETIME");
        public final static Property Remark = new Property(7, String.class, "remark", false, "REMARK");
        public final static Property DataType = new Property(8, int.class, "dataType", false, "DATA_TYPE");
        public final static Property ShowName = new Property(9, String.class, "showName", false, "SHOW_NAME");
    }


    public ExpandInfoDao(DaoConfig config) {
        super(config);
    }
    
    public ExpandInfoDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"EXPAND_INFO\" (" + //
                "\"_id\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: id
                "\"RESTAURANT_ID\" INTEGER," + // 1: restaurantId
                "\"SETTING_NAME\" TEXT," + // 2: settingName
                "\"VALUE_INT\" INTEGER," + // 3: valueInt
                "\"VALUE_CHAR\" TEXT," + // 4: valueChar
                "\"VALUE_BOOLEAN\" INTEGER," + // 5: valueBoolean
                "\"VALUE_DATETIME\" TEXT," + // 6: valueDatetime
                "\"REMARK\" TEXT," + // 7: remark
                "\"DATA_TYPE\" INTEGER NOT NULL ," + // 8: dataType
                "\"SHOW_NAME\" TEXT);"); // 9: showName
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"EXPAND_INFO\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, ExpandInfo entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        Integer restaurantId = entity.getRestaurantId();
        if (restaurantId != null) {
            stmt.bindLong(2, restaurantId);
        }
 
        String settingName = entity.getSettingName();
        if (settingName != null) {
            stmt.bindString(3, settingName);
        }
 
        Integer valueInt = entity.getValueInt();
        if (valueInt != null) {
            stmt.bindLong(4, valueInt);
        }
 
        String valueChar = entity.getValueChar();
        if (valueChar != null) {
            stmt.bindString(5, valueChar);
        }
 
        Boolean valueBoolean = entity.getValueBoolean();
        if (valueBoolean != null) {
            stmt.bindLong(6, valueBoolean ? 1L: 0L);
        }
 
        String valueDatetime = entity.getValueDatetime();
        if (valueDatetime != null) {
            stmt.bindString(7, valueDatetime);
        }
 
        String remark = entity.getRemark();
        if (remark != null) {
            stmt.bindString(8, remark);
        }
        stmt.bindLong(9, entity.getDataType());
 
        String showName = entity.getShowName();
        if (showName != null) {
            stmt.bindString(10, showName);
        }
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, ExpandInfo entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        Integer restaurantId = entity.getRestaurantId();
        if (restaurantId != null) {
            stmt.bindLong(2, restaurantId);
        }
 
        String settingName = entity.getSettingName();
        if (settingName != null) {
            stmt.bindString(3, settingName);
        }
 
        Integer valueInt = entity.getValueInt();
        if (valueInt != null) {
            stmt.bindLong(4, valueInt);
        }
 
        String valueChar = entity.getValueChar();
        if (valueChar != null) {
            stmt.bindString(5, valueChar);
        }
 
        Boolean valueBoolean = entity.getValueBoolean();
        if (valueBoolean != null) {
            stmt.bindLong(6, valueBoolean ? 1L: 0L);
        }
 
        String valueDatetime = entity.getValueDatetime();
        if (valueDatetime != null) {
            stmt.bindString(7, valueDatetime);
        }
 
        String remark = entity.getRemark();
        if (remark != null) {
            stmt.bindString(8, remark);
        }
        stmt.bindLong(9, entity.getDataType());
 
        String showName = entity.getShowName();
        if (showName != null) {
            stmt.bindString(10, showName);
        }
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public ExpandInfo readEntity(Cursor cursor, int offset) {
        ExpandInfo entity = new ExpandInfo( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.isNull(offset + 1) ? null : cursor.getInt(offset + 1), // restaurantId
            cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2), // settingName
            cursor.isNull(offset + 3) ? null : cursor.getInt(offset + 3), // valueInt
            cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4), // valueChar
            cursor.isNull(offset + 5) ? null : cursor.getShort(offset + 5) != 0, // valueBoolean
            cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6), // valueDatetime
            cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7), // remark
            cursor.getInt(offset + 8), // dataType
            cursor.isNull(offset + 9) ? null : cursor.getString(offset + 9) // showName
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, ExpandInfo entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setRestaurantId(cursor.isNull(offset + 1) ? null : cursor.getInt(offset + 1));
        entity.setSettingName(cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2));
        entity.setValueInt(cursor.isNull(offset + 3) ? null : cursor.getInt(offset + 3));
        entity.setValueChar(cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4));
        entity.setValueBoolean(cursor.isNull(offset + 5) ? null : cursor.getShort(offset + 5) != 0);
        entity.setValueDatetime(cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6));
        entity.setRemark(cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7));
        entity.setDataType(cursor.getInt(offset + 8));
        entity.setShowName(cursor.isNull(offset + 9) ? null : cursor.getString(offset + 9));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(ExpandInfo entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(ExpandInfo entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(ExpandInfo entity) {
        return entity.getId() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
}
