package com.gingersoft.gsa.cloud.greendao;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import com.gingersoft.gsa.cloud.database.bean.FoodModifier;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "FOOD_MODIFIER".
*/
public class FoodModifierDao extends AbstractDao<FoodModifier, Long> {

    public static final String TABLENAME = "FOOD_MODIFIER";

    /**
     * Properties of entity FoodModifier.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property Mid = new Property(1, Long.class, "mid", false, "MID");
        public final static Property Fid = new Property(2, Long.class, "fid", false, "FID");
        public final static Property MinQty = new Property(3, int.class, "minQty", false, "MIN_QTY");
        public final static Property MaxQty = new Property(4, int.class, "maxQty", false, "MAX_QTY");
        public final static Property SeqNo = new Property(5, int.class, "seqNo", false, "SEQ_NO");
        public final static Property CreateTime = new Property(6, String.class, "createTime", false, "CREATE_TIME");
        public final static Property CreateBy = new Property(7, String.class, "createBy", false, "CREATE_BY");
        public final static Property UpdateTime = new Property(8, String.class, "updateTime", false, "UPDATE_TIME");
        public final static Property ShowType = new Property(9, int.class, "showType", false, "SHOW_TYPE");
        public final static Property AutoNext = new Property(10, int.class, "autoNext", false, "AUTO_NEXT");
        public final static Property MultipleSelect = new Property(11, int.class, "multipleSelect", false, "MULTIPLE_SELECT");
        public final static Property Defmodifier = new Property(12, String.class, "defmodifier", false, "DEFMODIFIER");
        public final static Property Excmodifier = new Property(13, String.class, "excmodifier", false, "EXCMODIFIER");
        public final static Property Conditions = new Property(14, int.class, "conditions", false, "CONDITIONS");
        public final static Property IsRT = new Property(15, int.class, "isRT", false, "IS_RT");
        public final static Property RestaurantId = new Property(16, int.class, "restaurantId", false, "RESTAURANT_ID");
        public final static Property PreferentialPrice = new Property(17, int.class, "preferentialPrice", false, "PREFERENTIAL_PRICE");
        public final static Property PosId = new Property(18, int.class, "posId", false, "POS_ID");
    }


    public FoodModifierDao(DaoConfig config) {
        super(config);
    }
    
    public FoodModifierDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"FOOD_MODIFIER\" (" + //
                "\"_id\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: id
                "\"MID\" INTEGER NOT NULL ," + // 1: mid
                "\"FID\" INTEGER," + // 2: fid
                "\"MIN_QTY\" INTEGER NOT NULL ," + // 3: minQty
                "\"MAX_QTY\" INTEGER NOT NULL ," + // 4: maxQty
                "\"SEQ_NO\" INTEGER NOT NULL ," + // 5: seqNo
                "\"CREATE_TIME\" TEXT," + // 6: createTime
                "\"CREATE_BY\" TEXT," + // 7: createBy
                "\"UPDATE_TIME\" TEXT," + // 8: updateTime
                "\"SHOW_TYPE\" INTEGER NOT NULL ," + // 9: showType
                "\"AUTO_NEXT\" INTEGER NOT NULL ," + // 10: autoNext
                "\"MULTIPLE_SELECT\" INTEGER NOT NULL ," + // 11: multipleSelect
                "\"DEFMODIFIER\" TEXT," + // 12: defmodifier
                "\"EXCMODIFIER\" TEXT," + // 13: excmodifier
                "\"CONDITIONS\" INTEGER NOT NULL ," + // 14: conditions
                "\"IS_RT\" INTEGER NOT NULL ," + // 15: isRT
                "\"RESTAURANT_ID\" INTEGER NOT NULL ," + // 16: restaurantId
                "\"PREFERENTIAL_PRICE\" INTEGER NOT NULL ," + // 17: preferentialPrice
                "\"POS_ID\" INTEGER NOT NULL );"); // 18: posId
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"FOOD_MODIFIER\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, FoodModifier entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
        stmt.bindLong(2, entity.getMid());
 
        Long fid = entity.getFid();
        if (fid != null) {
            stmt.bindLong(3, fid);
        }
        stmt.bindLong(4, entity.getMinQty());
        stmt.bindLong(5, entity.getMaxQty());
        stmt.bindLong(6, entity.getSeqNo());
 
        String createTime = entity.getCreateTime();
        if (createTime != null) {
            stmt.bindString(7, createTime);
        }
 
        String createBy = entity.getCreateBy();
        if (createBy != null) {
            stmt.bindString(8, createBy);
        }
 
        String updateTime = entity.getUpdateTime();
        if (updateTime != null) {
            stmt.bindString(9, updateTime);
        }
        stmt.bindLong(10, entity.getShowType());
        stmt.bindLong(11, entity.getAutoNext());
        stmt.bindLong(12, entity.getMultipleSelect());
 
        String defmodifier = entity.getDefmodifier();
        if (defmodifier != null) {
            stmt.bindString(13, defmodifier);
        }
 
        String excmodifier = entity.getExcmodifier();
        if (excmodifier != null) {
            stmt.bindString(14, excmodifier);
        }
        stmt.bindLong(15, entity.getConditions());
        stmt.bindLong(16, entity.getIsRT());
        stmt.bindLong(17, entity.getRestaurantId());
        stmt.bindLong(18, entity.getPreferentialPrice());
        stmt.bindLong(19, entity.getPosId());
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, FoodModifier entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
        stmt.bindLong(2, entity.getMid());
 
        Long fid = entity.getFid();
        if (fid != null) {
            stmt.bindLong(3, fid);
        }
        stmt.bindLong(4, entity.getMinQty());
        stmt.bindLong(5, entity.getMaxQty());
        stmt.bindLong(6, entity.getSeqNo());
 
        String createTime = entity.getCreateTime();
        if (createTime != null) {
            stmt.bindString(7, createTime);
        }
 
        String createBy = entity.getCreateBy();
        if (createBy != null) {
            stmt.bindString(8, createBy);
        }
 
        String updateTime = entity.getUpdateTime();
        if (updateTime != null) {
            stmt.bindString(9, updateTime);
        }
        stmt.bindLong(10, entity.getShowType());
        stmt.bindLong(11, entity.getAutoNext());
        stmt.bindLong(12, entity.getMultipleSelect());
 
        String defmodifier = entity.getDefmodifier();
        if (defmodifier != null) {
            stmt.bindString(13, defmodifier);
        }
 
        String excmodifier = entity.getExcmodifier();
        if (excmodifier != null) {
            stmt.bindString(14, excmodifier);
        }
        stmt.bindLong(15, entity.getConditions());
        stmt.bindLong(16, entity.getIsRT());
        stmt.bindLong(17, entity.getRestaurantId());
        stmt.bindLong(18, entity.getPreferentialPrice());
        stmt.bindLong(19, entity.getPosId());
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public FoodModifier readEntity(Cursor cursor, int offset) {
        FoodModifier entity = new FoodModifier( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.getLong(offset + 1), // mid
            cursor.isNull(offset + 2) ? null : cursor.getLong(offset + 2), // fid
            cursor.getInt(offset + 3), // minQty
            cursor.getInt(offset + 4), // maxQty
            cursor.getInt(offset + 5), // seqNo
            cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6), // createTime
            cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7), // createBy
            cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8), // updateTime
            cursor.getInt(offset + 9), // showType
            cursor.getInt(offset + 10), // autoNext
            cursor.getInt(offset + 11), // multipleSelect
            cursor.isNull(offset + 12) ? null : cursor.getString(offset + 12), // defmodifier
            cursor.isNull(offset + 13) ? null : cursor.getString(offset + 13), // excmodifier
            cursor.getInt(offset + 14), // conditions
            cursor.getInt(offset + 15), // isRT
            cursor.getInt(offset + 16), // restaurantId
            cursor.getInt(offset + 17), // preferentialPrice
            cursor.getInt(offset + 18) // posId
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, FoodModifier entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setMid(cursor.getLong(offset + 1));
        entity.setFid(cursor.isNull(offset + 2) ? null : cursor.getLong(offset + 2));
        entity.setMinQty(cursor.getInt(offset + 3));
        entity.setMaxQty(cursor.getInt(offset + 4));
        entity.setSeqNo(cursor.getInt(offset + 5));
        entity.setCreateTime(cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6));
        entity.setCreateBy(cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7));
        entity.setUpdateTime(cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8));
        entity.setShowType(cursor.getInt(offset + 9));
        entity.setAutoNext(cursor.getInt(offset + 10));
        entity.setMultipleSelect(cursor.getInt(offset + 11));
        entity.setDefmodifier(cursor.isNull(offset + 12) ? null : cursor.getString(offset + 12));
        entity.setExcmodifier(cursor.isNull(offset + 13) ? null : cursor.getString(offset + 13));
        entity.setConditions(cursor.getInt(offset + 14));
        entity.setIsRT(cursor.getInt(offset + 15));
        entity.setRestaurantId(cursor.getInt(offset + 16));
        entity.setPreferentialPrice(cursor.getInt(offset + 17));
        entity.setPosId(cursor.getInt(offset + 18));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(FoodModifier entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(FoodModifier entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(FoodModifier entity) {
        return entity.getId() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
}
