package com.gingersoft.gsa.cloud.ui.view;

import android.content.Context;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.ViewPager;

import com.gingersoft.gsa.cloud.base.R;
import com.google.android.material.tabs.TabLayout;

import java.util.List;
import java.util.Objects;

public class MyTableView extends TabLayout {
    private List<String> titles;

    public MyTableView(@NonNull Context context) {
        super(context);
    }

    public MyTableView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public MyTableView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public MyTableView setTitles(List<String> titles) {
        this.titles = titles;
        return this;
    }

    @Override
    public void setupWithViewPager(@Nullable ViewPager viewPager) {
        super.setupWithViewPager(viewPager);
//        setTabsFromPagerAdapter(viewPager);//TabLayout的标签从Adapter中获取
        //用来循环适配器中的视图总数
        for (int i = 0; i < (titles != null ? titles.size() : 0); i++) {
            //获取每一个tab对象
            TabLayout.Tab tabAt = getTabAt(i);
            if (tabAt != null) {
                //将每一个条目设置我们自定义的视图
                tabAt.setCustomView(R.layout.layout_table_item);
                //默认选中第一个
                if (i == 0) {
                    // 设置第一个tab的TextView是被选择的样式
                    setSelectTab(tabAt, true);
                }
                //通过tab对象找到自定义视图的ID
                TextView textView = Objects.requireNonNull(tabAt.getCustomView()).findViewById(R.id.tv_tab);
                textView.setText(titles.get(i));//设置tab上的文字
            }
        }
        addOnTabSelectedListener(new TabLayout.OnTabSelectedListener() {
            @Override
            public void onTabSelected(TabLayout.Tab tab) {
                setSelectTab(tab, true);
            }

            @Override
            public void onTabUnselected(TabLayout.Tab tab) {
                setSelectTab(tab, false);
            }

            @Override
            public void onTabReselected(TabLayout.Tab tab) {

            }
        });
    }


    private void setSelectTab(TabLayout.Tab tabAt, boolean isSelected) {
        if (tabAt.getCustomView() != null) {
            TextView tab = tabAt.getCustomView().findViewById(R.id.tv_tab);//第一个tab被选中
            tab.setSelected(isSelected);
            //设置选中标签的文字大小
            tab.setTextSize(TypedValue.COMPLEX_UNIT_PX, isSelected ? getResources().getDimensionPixelSize(R.dimen.sp_16) : getResources().getDimensionPixelSize(R.dimen.sp_14));
            tab.getPaint().setFakeBoldText(isSelected);
        }
    }
}
