package com.gingersoft.gsa.cloud.manager.mvp.ui.adapter;

import android.content.Context;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import com.gingersoft.gsa.cloud.base.table.bean.TableArea;
import com.gingersoft.gsa.cloud.manager.R;
import com.gingersoft.gsa.cloud.manager.R2;
import com.jess.arms.base.BaseHolder;
import com.jess.arms.base.DefaultAdapter;

import java.util.List;

import butterknife.BindView;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/6/27
 * 修订历史：2018/6/27
 * 描述：餐檯管理列表
 */

public class AreaManageAdapter extends DefaultAdapter<TableArea> {

    private Context mContext;
    private boolean isRadioEdit;

    public AreaManageAdapter(Context context, List<TableArea> infos) {
        super(infos);
        this.mContext = context;
    }

    @Override
    public int getItemCount() {
        return mInfos.size();
    }

    @Override
    public BaseHolder<TableArea> getHolder(View v, int viewType) {
        return new TopTableAreaItemHolder(v);
    }

    @Override
    public int getLayoutId(int viewType) {
        return R.layout.manager_item_manage_area;
    }

    public class TopTableAreaItemHolder extends BaseHolder<TableArea> {

        @BindView(R2.id.ed_name)
        EditText ed_name;
        //        @BindView(R2.id.ed_input_name)
//        TextView ed_input_name;
        @BindView(R2.id.cb_checked)
        CheckBox cb_checked;

        public TopTableAreaItemHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void setData(TableArea datasBean, int position) {
            ed_name.setText(datasBean.getRegionName());
            ed_name.setOnFocusChangeListener(new View.OnFocusChangeListener() {
                @Override
                public void onFocusChange(View v, boolean hasFocus) {
                    if (!hasFocus) {
                        String name = ed_name.getText().toString();
                        if (onTextChangedListener != null && !name.equals(datasBean.getRegionName())) {
                            onTextChangedListener.afterTextChanged(datasBean, name);
                        }
                    }
                }
            });
//            tv_edit.setOnClickListener(new View.OnClickListener() {
//                @Override
//                public void onClick(View v) {
//                    if (onClickListener != null)
//                        onClickListener.onItemClick(v, datasBean);
//                }
//            });
            if (isRadioEdit) {
                cb_checked.setVisibility(View.VISIBLE);
                cb_checked.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
                    @Override
                    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                        buttonView.setChecked(isChecked);
                        datasBean.setChecked(isChecked);
                    }
                });
                ed_name.setCursorVisible(true);
                ed_name.setFocusable(true);
                ed_name.setFocusableInTouchMode(true);
            } else {
                cb_checked.setVisibility(View.GONE);
                ed_name.setCursorVisible(false);
                ed_name.setFocusable(false);
                ed_name.setFocusableInTouchMode(false);
            }
            cb_checked.setChecked(datasBean.isChecked());
        }
    }

    public void setRadioEdit(boolean radioEdit) {
        isRadioEdit = radioEdit;
    }

    private OnTextChangedListener onTextChangedListener;

    public void addTextChangedListener(OnTextChangedListener onTextChangedListener) {
        this.onTextChangedListener = onTextChangedListener;
    }

    public interface OnTextChangedListener {

        void afterTextChanged(TableArea datasBean, String s);

    }
}
