package com.gingersoft.gsa.cloud.base.order.bean;

import java.util.ArrayList;
import java.util.List;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-07-25
 * 修订历史：2020-07-25
 * 描述：
 */
@Data
public class OrderPayRequest {

    private long orderId;
    private int linePayType;
    private int orderPayType;
    private int tableId;
    private String tableNumber;
    private Long memberId;
    private Long couponId;
    /**當前加的積分*/
    private Double pointsAdd;
    /**當前減去的積分*/
    private Double pointsUse;
    /**
     * 是否免服務費(0:否 1：是)
     */
    private int whetherFreeService;
    private List<OrderPay> orderPays = new ArrayList<>();

    @Data
    public static class OrderPay {
        private int payType;
        private double amount;
        private double tipsPrice;
        /**積分支付 所消費的積分*/
        private Double consumptionPoints;

        public int getPayType() {
            return payType;
        }

        public void setPayType(int payType) {
            this.payType = payType;
        }

        public double getAmount() {
            return amount;
        }

        public void setAmount(double amount) {
            this.amount = amount;
        }

        public double getTipsPrice() {
            return tipsPrice;
        }

        public void setTipsPrice(double tipsPrice) {
            this.tipsPrice = tipsPrice;
        }

        public Double getConsumptionPoints() {
            return consumptionPoints;
        }

        public void setConsumptionPoints(Double consumptionPoints) {
            this.consumptionPoints = consumptionPoints;
        }
    }

    public long getOrderId() {
        return orderId;
    }

    public void setOrderId(long orderId) {
        this.orderId = orderId;
    }

    public int getLinePayType() {
        return linePayType;
    }

    public void setLinePayType(int linePayType) {
        this.linePayType = linePayType;
    }

    public int getOrderPayType() {
        return orderPayType;
    }

    public void setOrderPayType(int orderPayType) {
        this.orderPayType = orderPayType;
    }

    public int getTableId() {
        return tableId;
    }

    public void setTableId(int tableId) {
        this.tableId = tableId;
    }

    public String getTableNumber() {
        return tableNumber;
    }

    public void setTableNumber(String tableNumber) {
        this.tableNumber = tableNumber;
    }

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public Long getCouponId() {
        return couponId;
    }

    public void setCouponId(Long couponId) {
        this.couponId = couponId;
    }

    public Double getPointsAdd() {
        return pointsAdd;
    }

    public void setPointsAdd(Double pointsAdd) {
        this.pointsAdd = pointsAdd;
    }

    public Double getPointsUse() {
        return pointsUse;
    }

    public void setPointsUse(Double pointsUse) {
        this.pointsUse = pointsUse;
    }

    public int getWhetherFreeService() {
        return whetherFreeService;
    }

    public void setWhetherFreeService(int whetherFreeService) {
        this.whetherFreeService = whetherFreeService;
    }

    public List<OrderPay> getOrderPays() {
        return orderPays;
    }

    public void setOrderPays(List<OrderPay> orderPays) {
        this.orderPays = orderPays;
    }
}
